/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import java.util.UUID;

public class UUIDUtil {
    private static final char DASH = '-';
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toString(UUID uuid) {
        char[] chars = new char[36];
        chars[8] = 45;
        chars[13] = 45;
        chars[18] = 45;
        chars[23] = 45;
        UUIDUtil.digits(uuid.getMostSignificantBits() >> 32, 8, chars, 0);
        UUIDUtil.digits(uuid.getMostSignificantBits() >> 16, 4, chars, 9);
        UUIDUtil.digits(uuid.getMostSignificantBits(), 4, chars, 14);
        UUIDUtil.digits(uuid.getLeastSignificantBits() >> 48, 4, chars, 19);
        UUIDUtil.digits(uuid.getLeastSignificantBits(), 12, chars, 24);
        return new String(chars);
    }

    private static void digits(long val, int digits, char[] chars, int idx) {
        long hi = 1L << digits * 4;
        UUIDUtil.toUnsignedString0(hi | val & hi - 1L, chars, idx);
    }

    private static void toUnsignedString0(long val, char[] chars, int idx) {
        int mag = 64 - Long.numberOfLeadingZeros(val);
        int len = Math.max((mag + 3) / 4, 1);
        UUIDUtil.formatUnsignedLong(val, chars, idx, len);
    }

    private static void formatUnsignedLong(long val, char[] buf, int offset, int len) {
        int charPos = len;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[-1 + offset + --charPos] = DIGITS[(int)val & mask];
        } while ((val >>>= 4) != 0L && charPos > 1);
    }
}

