/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.util;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public final class XmlUtil {
    public static Collection<DOMError> validateWithSchema(Document doc, URL schema, final Predicate<String> predicate) {
        final ArrayList<DOMError> result = new ArrayList<DOMError>();
        final Logger log = LoggerFactory.getLogger(XmlUtil.class);
        DOMConfiguration config = doc.getDomConfig();
        config.setParameter("schema-type", "http://www.w3.org/2001/XMLSchema");
        config.setParameter("validate", Boolean.TRUE);
        config.setParameter("schema-location", schema.toExternalForm());
        config.setParameter("well-formed", Boolean.TRUE);
        config.setParameter("error-handler", new DOMErrorHandler(){

            @Override
            public boolean handleError(DOMError error) {
                Node parent;
                StringBuilder buf = new StringBuilder();
                buf.append(error.getMessage()).append(" [Error details: ");
                DOMLocator location = error.getLocation();
                Node relatedNode = location.getRelatedNode();
                if (relatedNode != null && (parent = relatedNode.getParentNode()) != null) {
                    buf.append("parent node content - ").append(parent.getTextContent()).append(';');
                }
                buf.append(']');
                String message = buf.toString();
                switch (error.getSeverity()) {
                    case 1: {
                        log.warn(message);
                        break;
                    }
                    case 2: {
                        if (predicate != null && predicate.test(message)) {
                            log.warn(message);
                            break;
                        }
                        log.error(message);
                        break;
                    }
                    case 3: {
                        log.error(message);
                    }
                }
                result.add(error);
                return true;
            }
        });
        doc.normalizeDocument();
        return result;
    }

    public static Map<String, String> getAttributes(Element elm) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        NamedNodeMap attributes = elm.getAttributes();
        int c = attributes.getLength();
        for (int i = 0; i < c; ++i) {
            Node item = attributes.item(i);
            result.put(item.getNodeName(), item.getNodeValue());
        }
        return result;
    }

    public static Element getChild(Element elm, String localName) {
        for (Element child : XmlUtil.getChildren(elm)) {
            if (child.getTagName().equals(localName)) {
                return child;
            }
            if (!child.getTagName().endsWith(":" + localName)) continue;
            return child;
        }
        return null;
    }

    public static Element[] getChildren(Element elm) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = elm.getChildNodes();
        int c = children.getLength();
        for (int i = 0; i < c; ++i) {
            Node child = XmlUtil.safeGetNode(children, i);
            if (child == elm || child.getNodeType() != 1) continue;
            result.add((Element)child);
        }
        return result.toArray(new Element[result.size()]);
    }

    public static Element[] getElements(Element elm, String path) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        if (path == null || "".equals(path) || ".".equals(path) || path.endsWith("/") || path.indexOf(64) != -1) {
            throw new IllegalArgumentException("invalid path " + path);
        }
        if (path.startsWith("/")) {
            Element root = elm.getOwnerDocument().getDocumentElement();
            String subPath = path.substring(1);
            int p = subPath.indexOf(47);
            if (p == -1) {
                if (root.getTagName().equals(subPath)) {
                    return new Element[]{root};
                }
                return new Element[0];
            }
            if (root.getTagName().equals(subPath.substring(0, p))) {
                return XmlUtil.getElements(root, subPath.substring(p + 1));
            }
            return new Element[0];
        }
        if (path.startsWith("./")) {
            return XmlUtil.getElements(elm, path.substring(2));
        }
        ArrayList<Element> result = new ArrayList<Element>();
        int p = path.indexOf(47);
        if (p == -1) {
            NodeList children = elm.getChildNodes();
            int c = children.getLength();
            for (int i = 0; i < c; ++i) {
                Node child = XmlUtil.safeGetNode(children, i);
                if (child == elm || child.getNodeType() != 1 || !"*".equals(path) && !path.equals(child.getNodeName())) continue;
                result.add((Element)child);
            }
        } else {
            Element[] elms;
            for (Element elm2 : elms = XmlUtil.getElements(elm, path.substring(0, p))) {
                Element[] subElms;
                for (Element subElm : subElms = XmlUtil.getElements(elm2, path.substring(p + 1))) {
                    result.add(subElm);
                }
            }
        }
        return result.toArray(new Element[result.size()]);
    }

    public static Element getElement(Element elm, String path) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        if (path == null || "".equals(path) || path.endsWith("/") || path.indexOf(64) != -1) {
            throw new IllegalArgumentException("invalid path " + path);
        }
        if (".".equals(path)) {
            return elm;
        }
        if (path.startsWith("/")) {
            Element root = elm.getOwnerDocument().getDocumentElement();
            String subPath = path.substring(1);
            int p = subPath.indexOf(47);
            if (p == -1) {
                if (root.getTagName().equals(subPath)) {
                    return root;
                }
                return null;
            }
            if (root.getTagName().equals(subPath.substring(0, p))) {
                return XmlUtil.getElement(root, subPath.substring(p + 1));
            }
            return null;
        }
        if (path.startsWith("./")) {
            return XmlUtil.getElement(elm, path.substring(2));
        }
        StringTokenizer st = new StringTokenizer(path, "/", false);
        Element currElm = elm;
        Element nextElm;
        while ((nextElm = XmlUtil.findChild(currElm, st.nextToken())) != null) {
            if (!st.hasMoreTokens()) {
                return nextElm;
            }
            currElm = nextElm;
        }
        return null;
    }

    public static Element findElement(Element elm, String elementsPath, String filterPath, String filterValue) {
        return XmlUtil.findElement(XmlUtil.getElements(elm, elementsPath), filterPath, filterValue);
    }

    public static Element findElement(Element[] elms, String filterPath, String filterValue) {
        for (Element elm : elms) {
            if (!filterValue.equals(XmlUtil.getValue(elm, filterPath))) continue;
            return elm;
        }
        return null;
    }

    public static String getValue(Element elm, String path) {
        int p = path.indexOf(64);
        if (p == 0) {
            Attr attr = elm.getAttributeNode(path.substring(1));
            return attr == null ? null : attr.getNodeValue();
        }
        String elmPath = p == -1 ? path : path.substring(0, p);
        String attrName = p == -1 ? null : path.substring(p + 1);
        Element subElm = XmlUtil.getElement(elm, elmPath);
        if (subElm == null) {
            return null;
        }
        if (attrName != null) {
            Attr attr = subElm.getAttributeNode(attrName);
            return attr == null ? null : attr.getNodeValue();
        }
        return XmlUtil.getValue(subElm);
    }

    public static String getValue(Element elm) {
        return XmlUtil.getValue(elm, false);
    }

    public static String getValue(Element elm, boolean recursive, boolean trim) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        NodeList children = elm.getChildNodes();
        int c = children.getLength();
        StringBuilder result = new StringBuilder();
        block5: for (int i = 0; i < c; ++i) {
            Node child = XmlUtil.safeGetNode(children, i);
            if (child == elm) continue;
            switch (child.getNodeType()) {
                case 4: {
                    result.append(child.getNodeValue());
                    continue block5;
                }
                case 3: {
                    result.append(trim ? child.getNodeValue().trim() : child.getNodeValue());
                    continue block5;
                }
                case 1: {
                    if (!recursive) continue block5;
                    result.append(XmlUtil.getValue((Element)child, recursive));
                }
            }
        }
        String value = result.toString();
        if (elm.hasAttribute("g9-escaped") && MiscUtil.isTrue(elm.getAttribute("g9-escaped"))) {
            value = XmlHelper.unescapeString(value);
        }
        return value;
    }

    public static String getValue(Element elm, boolean recursive) {
        return XmlUtil.getValue(elm, recursive, true);
    }

    public static String findValue(Element elm, String elementsPath, String filterPath, String filterValue, String valuePath) {
        return XmlUtil.findValue(XmlUtil.getElements(elm, elementsPath), filterPath, filterValue, valuePath);
    }

    public static String findValue(Element[] elms, String filterPath, String filterValue, String valuePath) {
        for (Element elm : elms) {
            if (!filterValue.equals(XmlUtil.getValue(elm, filterPath))) continue;
            return XmlUtil.getValue(elm, valuePath);
        }
        return null;
    }

    public static Element setValue(Element elm, String value) {
        return XmlUtil.setValue(elm, value, false);
    }

    public static Element setValue(Element elm, String value, boolean asCdata) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        NodeList children = elm.getChildNodes();
        int c = children.getLength();
        for (int i = 0; i < c; ++i) {
            Node child = XmlUtil.safeGetNode(children, i);
            if (child == elm) continue;
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    elm.removeChild(child);
                }
            }
        }
        String _value = value;
        if (_value != null && XmlHelper.containsInvalidCharacters(_value)) {
            _value = XmlHelper.escapeString(_value);
            elm.setAttribute("g9-escaped", Boolean.toString(true));
        }
        if (asCdata) {
            elm.appendChild(elm.getOwnerDocument().createCDATASection(_value != null ? _value : ""));
        } else {
            elm.appendChild(elm.getOwnerDocument().createTextNode(_value != null ? _value : ""));
        }
        return elm;
    }

    public static Element addElement(Element elm, String path) {
        return XmlUtil.addElement(elm, path, false);
    }

    public static Element addElementAttribute(Element elm, String path) {
        return XmlUtil.addElementAttribute(elm, path, false);
    }

    public static Element addElement(Element elm1, Element elm2, String path, boolean forceNewElement) {
        if (elm1 == null || elm2 == null) {
            throw new IllegalArgumentException("element argement is NULL");
        }
        if (path == null || "".equals(path) || path.startsWith(".") || path.startsWith("/") || path.endsWith("/") || path.indexOf(64) != -1) {
            throw new IllegalArgumentException("invalid path " + path);
        }
        Element result = elm1;
        String[] arr = path.split("/");
        for (int i = 0; i < arr.length; ++i) {
            boolean found;
            Element child = XmlUtil.findChildLast(result, arr[i]);
            boolean bl = found = child != null && i < arr.length - 1;
            if (found) {
                result = child;
                continue;
            }
            if (child != null && !forceNewElement) {
                result = (Element)child.appendChild(elm2);
                continue;
            }
            if (result == null) continue;
            result = (Element)result.appendChild(elm1.getOwnerDocument().createElementNS("", arr[i]));
            result = (Element)result.appendChild(elm2);
        }
        return result;
    }

    public static Element addElement(Element elm, String path, boolean noDuplicate) {
        return XmlUtil.addElement(elm, path, noDuplicate, "");
    }

    public static Element addElement(Element elm, String path, boolean noDuplicate, String namespace) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        if (path == null || "".equals(path) || path.startsWith(".") || path.startsWith("/") || path.endsWith("/") || path.indexOf(64) != -1) {
            throw new IllegalArgumentException("invalid path " + path);
        }
        Element result = elm;
        String[] arr = path.split("/");
        for (int i = 0; i < arr.length; ++i) {
            boolean found;
            Element child = XmlUtil.findChild(result, arr[i]);
            boolean bl = found = child != null && i < arr.length - 1;
            result = found && !noDuplicate || noDuplicate && child != null ? child : (Element)result.appendChild(elm.getOwnerDocument().createElementNS(namespace == null ? "" : namespace, arr[i]));
        }
        return result;
    }

    public static Element addElementAttribute(Element elm, String path, boolean noDuplicate) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        if (path == null || "".equals(path) || path.startsWith(".") || path.startsWith("/") || path.endsWith("/")) {
            throw new IllegalArgumentException("invalid path " + path);
        }
        Element result = elm;
        String[] arr = path.split("/");
        for (int i = 0; i < arr.length; ++i) {
            Element child;
            if (arr[i].contains("@") && i < arr.length - 1) {
                return null;
            }
            String curPart = arr[i];
            if (curPart.contains("@")) {
                curPart = curPart.substring(0, curPart.indexOf("@"));
            }
            boolean found = (child = XmlUtil.findChildLast(result, curPart)) != null;
            result = found && !noDuplicate || noDuplicate && child != null ? child : (Element)result.appendChild(elm.getOwnerDocument().createElementNS("", curPart));
        }
        return result;
    }

    public static void deleteChild(Element elm, String tagName) {
        Element child = XmlUtil.findChild(elm, tagName);
        if (child != null) {
            elm.removeChild(child);
        }
    }

    public static Element findChild(Element elm, String tagName) {
        NodeList children = elm.getChildNodes();
        int c = children.getLength();
        for (int i = 0; i < c; ++i) {
            Node child = XmlUtil.safeGetNode(children, i);
            if (child == elm || child.getNodeType() != 1 || !tagName.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    private static Element findChildLast(Element elm, String tagName) {
        Element result = null;
        NodeList children = elm.getChildNodes();
        int c = children.getLength();
        for (int i = 0; i < c; ++i) {
            Node child = XmlUtil.safeGetNode(children, i);
            if (child == elm || child.getNodeType() != 1 || !tagName.equals(child.getNodeName())) continue;
            result = (Element)child;
        }
        return result;
    }

    public static Element addElement(Element elm, String path, String value, int maxValueLength) {
        return XmlUtil.addElement(elm, path, value != null && value.length() > maxValueLength ? value.substring(0, maxValueLength) : value, false);
    }

    public static Element addElement(Element elm, String path, String value) {
        return XmlUtil.addElement(elm, path, value, false);
    }

    public static Element addElement(Element elm, String path, String value, int maxValueLength, boolean asCdata) {
        return XmlUtil.addElement(elm, path, value != null && value.length() > maxValueLength ? value.substring(0, maxValueLength) : value, asCdata);
    }

    public static Element addElement(Element elm, String path, String value, boolean asCdata) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        Element result = XmlUtil.addElement(elm, path);
        if (value != null) {
            if (asCdata) {
                result.appendChild(elm.getOwnerDocument().createCDATASection(value));
            } else {
                result.appendChild(elm.getOwnerDocument().createTextNode(value));
            }
        }
        return result;
    }

    public static Element[] cloneElement(Element elm, int count) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        Element parent = (Element)elm.getParentNode();
        if (parent == null) {
            throw new IllegalArgumentException("parent element of " + elm + " is NULL");
        }
        if (parent.getNodeType() != 1) {
            throw new IllegalArgumentException("parent node of " + elm + " is not element node");
        }
        Element[] result = new Element[count + 1];
        for (int i = 0; i < count; ++i) {
            result[i] = (Element)parent.insertBefore(elm.cloneNode(true), elm);
        }
        result[result.length - 1] = elm;
        return result;
    }

    public static Element cloneElement(Element elm) {
        if (elm == null) {
            throw new IllegalArgumentException("element is NULL");
        }
        Element parent = (Element)elm.getParentNode();
        if (parent == null) {
            throw new IllegalArgumentException("parent element of " + elm + " is NULL");
        }
        if (parent.getNodeType() != 1) {
            throw new IllegalArgumentException("parent node of " + elm + " is not element node");
        }
        return (Element)parent.insertBefore(elm.cloneNode(true), elm);
    }

    public static void cleanupElement(Element elm) {
        if (elm == null) {
            return;
        }
        NodeList children = elm.getChildNodes();
        int c = children.getLength();
        ArrayList<Node> nodesToDelete = new ArrayList<Node>();
        block4: for (int i = 0; i < c; ++i) {
            Node child = XmlUtil.safeGetNode(children, i);
            if (child == elm) continue;
            switch (child.getNodeType()) {
                case 8: {
                    nodesToDelete.add(child);
                    continue block4;
                }
                case 1: {
                    XmlUtil.cleanupElement((Element)child);
                }
            }
        }
        for (Node node : nodesToDelete) {
            elm.removeChild(node);
        }
    }

    public static boolean compareNodes(Node node1, Node node2, boolean nullIsTrue) {
        if (nullIsTrue && node1 == null && node2 == null) {
            return true;
        }
        if (node1 == null || node2 == null) {
            return false;
        }
        if (!node1.getNodeName().equals(node2.getNodeName()) || node1.getNodeType() != node2.getNodeType()) {
            return false;
        }
        String value1 = node1.getNodeValue();
        String value2 = node2.getNodeValue();
        if (value1 == null && value2 != null) {
            return false;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        if (value1 != null && value2 != null && !value1.equals(value2)) {
            return false;
        }
        NodeList children1 = node1.getChildNodes();
        NodeList children2 = node2.getChildNodes();
        if (children1.getLength() != children2.getLength()) {
            return false;
        }
        int len = children1.getLength();
        for (int i = 0; i < len; ++i) {
            Node child1 = XmlUtil.safeGetNode(children1, i);
            Node child2 = XmlUtil.safeGetNode(children2, i);
            if (node1 == child1) {
                if (node2 == child2) continue;
                return false;
            }
            if (child2 == node2) {
                return false;
            }
            if (XmlUtil.compareNodes(child1, child2, nullIsTrue)) continue;
            return false;
        }
        return true;
    }

    public static String getPath(Node node) {
        if (node == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        block5: for (Node parent = node; parent != null; parent = parent.getParentNode()) {
            String nodeName = parent.getNodeName();
            switch (parent.getNodeType()) {
                case 9: {
                    continue block5;
                }
                case 2: {
                    result.insert(0, '@' + nodeName);
                    continue block5;
                }
                case 1: {
                    result.insert(0, '/' + nodeName);
                    continue block5;
                }
                default: {
                    result.insert(0, '[' + nodeName + ']');
                }
            }
        }
        return result.toString();
    }

    public static Node safeGetNode(NodeList nodeList, int idx) {
        if (idx < 0 || idx >= nodeList.getLength()) {
            return null;
        }
        Node result = nodeList.item(idx);
        if (result == null) {
            result = nodeList.item(idx);
        }
        return result;
    }

    private XmlUtil() {
    }
}

