/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml.xstream.converters;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class XStreamDateTimeConverter
implements SingleValueConverter {
    private final String format;

    public XStreamDateTimeConverter(String format) {
        this.format = format;
    }

    public boolean canConvert(Class type) {
        return DateTime.class.equals((Object)type);
    }

    public Object fromString(String str) {
        if (TextUtil.isBlank(str)) {
            return null;
        }
        try {
            return DateTime.parse((String)str, (DateTimeFormatter)DateTimeFormat.forPattern((String)this.format));
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("fromString failed", ex, new Object[0]);
        }
    }

    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            DateTime dateTime = (DateTime)obj;
            return dateTime.toString(DateTimeFormat.forPattern((String)this.format));
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("toString failed", ex, new Object[0]);
        }
    }
}

