/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml.xstream.converters;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class XStreamJavaLocalDateTimeConverter
implements SingleValueConverter {
    private final DateTimeFormatter dtf;

    public XStreamJavaLocalDateTimeConverter(String format) {
        this.dtf = DateTimeFormatter.ofPattern(format);
    }

    public boolean canConvert(Class type) {
        return LocalDateTime.class.equals((Object)type);
    }

    public Object fromString(String str) {
        if (TextUtil.isBlank(str)) {
            return null;
        }
        try {
            return LocalDateTime.parse(str, this.dtf);
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("fromString failed", ex, new Object[0]);
        }
    }

    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            LocalDateTime localDateTime = (LocalDateTime)obj;
            return localDateTime.format(this.dtf);
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("toString failed", ex, new Object[0]);
        }
    }
}

