/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml.xstream.converters;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class XStreamLocalDateTimeConverter
implements SingleValueConverter {
    private final String format;

    public XStreamLocalDateTimeConverter(String format) {
        this.format = format;
    }

    public boolean canConvert(Class type) {
        return LocalDateTime.class.equals((Object)type);
    }

    public Object fromString(String str) {
        if (TextUtil.isBlank(str)) {
            return null;
        }
        try {
            return LocalDateTime.parse((String)str, (DateTimeFormatter)DateTimeFormat.forPattern((String)this.format));
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("fromString failed", ex, new Object[0]);
        }
    }

    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            LocalDateTime localDateTime = (LocalDateTime)obj;
            return localDateTime.toString(DateTimeFormat.forPattern((String)this.format));
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("toString failed", ex, new Object[0]);
        }
    }
}

