/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.xml.xstream.converters;

import com.gridnine.xtrip.common.model.Xeption;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.joda.time.Duration;

public class XStreamTimeDurationConverter
implements SingleValueConverter {
    public boolean canConvert(Class type) {
        return Duration.class.equals((Object)type);
    }

    public Object fromString(String str) {
        try {
            String[] values = str.split(":");
            int hours = Integer.valueOf(values[0]);
            int minutes = Integer.valueOf(values[1]);
            return new Duration((long)((hours * 60 + minutes) * 60 * 1000));
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("fromString failed", ex, new Object[0]);
        }
    }

    public String toString(Object obj) {
        try {
            Duration duration = (Duration)obj;
            long minutes = duration.getStandardMinutes();
            long hours = minutes / 60L;
            return String.format("%s:%s", hours, minutes %= 60L);
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper("toString failed", ex, new Object[0]);
        }
    }
}

