/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core;

import com.gridnine.xtrip.client.fx.core.Main;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.StandardRichContentHandlers;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.Configurator;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.startup.AutoUpdate;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistryConfigurator;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.EnumItemRenamer;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.plugin.BaseApplicationPlugin;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.usage.FakeIndexUsageHandler;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XmlEnumItemRenamer;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.Boot;
import org.java.plugin.boot.ErrorDialog;
import org.java.plugin.registry.Extension;
import org.java.plugin.util.ExtendedProperties;

public class ClientPlugin
extends BaseApplicationPlugin {
    private String[] cmdArgs;

    protected void configure(ExtendedProperties config, String[] args) throws Exception {
        this.cmdArgs = args;
        this.populateSystemProperties();
        Environment.publish((Object)new UserData(() -> ServiceInvocationContext.get().getUser()));
        Environment.publish((Object)this.createUniqueSettingsRegistry());
        Environment.publish((Object)new EventBus());
        LocaleManager lm = this.createLocaleManager();
        Environment.publish((Object)lm);
        Locale loc = ClientSettings.get().getUiLocale();
        lm.setDefaultLocale(loc);
        lm.setCurrentLocale(loc);
        Locale.setDefault(loc);
        ClientSettings.get().setProperties(config);
        Environment.publish((Object)this.createMetaRegistry());
        Environment.publish((Object)this.createUiMetaRegistry());
        Environment.publish((Object)this.createClientRegistry());
        Environment.publish(IndexUsageHandler.class, (Object)new FakeIndexUsageHandler());
    }

    private UniqueSettingsRegistry createUniqueSettingsRegistry() throws Exception {
        UniqueSettingsRegistry registry = new UniqueSettingsRegistry();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"UniqueSettingsRegistryConfigurator")) {
            this.log.debug((Object)("processing UniqueSettingsRegistryConfigurator from " + ext));
            try {
                Class cls = JpfUtil.getClass((Extension)ext, (String)"class");
                ((UniqueSettingsRegistryConfigurator)cls.newInstance()).configure(registry);
            }
            catch (Exception e) {
                this.log.error((Object)("failed configuring UniqueSettingsRegistry from " + ext), (Throwable)e);
            }
        }
        return registry;
    }

    private ClientRegistry createClientRegistry() throws Exception {
        ClientRegistry result = new ClientRegistry();
        result.register(StandardRenderers.values());
        result.register(StandardRichContentHandlers.values());
        result.register(StandardKeyBindingActions.values());
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.client.fx.core", (String)"ClientRegistryConfigurator")) {
            this.log.info((Object)("applying client registry configurator from " + ext));
            ((Configurator)JpfUtil.getClass((Extension)ext).newInstance()).configure(result);
        }
        return result;
    }

    private void populateSystemProperties() throws Exception {
        PluginManager pm = PluginManager.lookup((Object)((Object)this));
        if (pm == null) {
            return;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"SystemProperties")) {
            URL url = JpfUtil.getResource((Extension)ext, (String)"location");
            this.log.debug((Object)("loading system properties from " + url));
            Properties prop = new Properties();
            try (InputStream in = url.openStream();){
                prop.load(in);
            }
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                String value = System.getProperty((String)entry.getKey());
                if (value == null) {
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                this.log.info((Object)String.format("ignoring override of system property %s, currentValue=%s, newValue=%s", entry.getKey(), value, entry.getValue()));
            }
            this.log.info((Object)("loaded system properties from " + url));
        }
    }

    private LocaleManager createLocaleManager() {
        LocaleManager localeManager = new LocaleManager();
        PluginManager pluginManager = PluginManager.lookup((Object)((Object)this));
        if (Objects.isNull(pluginManager)) {
            return localeManager;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common.fx.core", (String)"SupportedLocale")) {
            localeManager.registerSupportedLocale(TextUtil.str2locale((String)ext.getParameter("id").valueAsString()));
        }
        for (Extension extension : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"L10nResources")) {
            Extension.Parameter locationParameter = extension.getParameter("location");
            Extension.Parameter baseFileNameParameter = extension.getParameter("baseFileName");
            URL locationUrl = pluginManager.getPluginClassLoader(locationParameter.getDeclaringPluginDescriptor()).getResource(locationParameter.valueAsString());
            String baseFileName = Optional.ofNullable(baseFileNameParameter).map(Extension.Parameter::valueAsString).orElse(null);
            localeManager.getL10nResourceManager().registerResource(locationUrl, baseFileName);
        }
        return localeManager;
    }

    private MetaRegistry createMetaRegistry() {
        final MetaRegistry metaRegistry = new MetaRegistry();
        Environment.publish(XmlEnumItemRenamer.class, (Object)new XmlEnumItemRenamer(){

            public String rename(String value, String className) {
                String result = value;
                EnumType enumType = (EnumType)metaRegistry.getEnums().get(className);
                if (enumType == null) {
                    return result;
                }
                for (String renamerClass : enumType.getEnumItemRenamers()) {
                    EnumItemRenamer renamer = metaRegistry.findEnumItemRenamer(renamerClass);
                    if (renamer == null) continue;
                    result = renamer.getNewName(result);
                }
                return result;
            }
        });
        PluginManager pm = PluginManager.lookup((Object)((Object)this));
        if (pm == null) {
            return metaRegistry;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"MetaDescriptors")) {
            for (Extension.Parameter param : ext.getParameters("location")) {
                try {
                    metaRegistry.register(pm.getPluginClassLoader(param.getDeclaringPluginDescriptor()).getResource(param.valueAsString()));
                }
                catch (Exception e) {
                    this.log.error((Object)("failed configuring meta from " + param), (Throwable)e);
                }
            }
        }
        return metaRegistry;
    }

    private UiMetaRegistry createUiMetaRegistry() {
        UiMetaRegistry result = new UiMetaRegistry();
        PluginManager pm = PluginManager.lookup((Object)((Object)this));
        if (pm == null) {
            return result;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"UiMetaDescriptors")) {
            for (Extension.Parameter param : ext.getParameters("location")) {
                try {
                    result.register(pm.getPluginClassLoader(param.getDeclaringPluginDescriptor()).getResource(param.valueAsString()));
                }
                catch (Exception e) {
                    this.log.error((Object)("failed configuring UI metadata from " + param), (Throwable)e);
                }
            }
        }
        return result;
    }

    public void startApplication() throws Exception {
        ErrorHandler.register(error -> {
            error.printStackTrace();
            ErrorDialog.showError(null, (String)"An error has occurred", (Throwable)error);
        });
        new Thread(() -> {
            try {
                AutoUpdate.startup((Application)this);
                Main.start((Application)this, this.cmdArgs);
            }
            catch (Throwable t) {
                ErrorHandler.handle(t);
                try {
                    Boot.stopApplication((Application)this);
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
                System.exit(1);
            }
        }, "startup process").start();
    }

    protected void doStop() throws Exception {
        Environment.dispose();
        super.doStop();
    }
}

