/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.action;

import com.gridnine.xtrip.client.fx.core.action.Action;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindings;
import com.gridnine.xtrip.client.fx.core.kb.ShortcutHandler;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerExpression;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public abstract class ActionsPane<A extends Action<?> & RegistryItem<?>>
extends BorderPane
implements ShortcutHandler {
    private static final PseudoClass EXPANDED_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"expanded");
    private static final String STYLE_CLASS_DEFAULT = "default";
    private final VBox contentPane = new VBox();
    private A defaultAction;
    private boolean expanded = false;
    private final IntegerExpression actionsCount;

    public ActionsPane() {
        this.contentPane.getStyleClass().add((Object)"actions-content-pane");
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.getStyleClass().add((Object)"edge-to-edge");
        scrollPane.setFitToWidth(true);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setContent((Node)this.contentPane);
        this.setCenter((Node)scrollPane);
        this.actionsCount = Bindings.size((ObservableList)this.contentPane.getChildren());
    }

    protected abstract void execute(Control var1, A var2, boolean var3);

    protected abstract boolean isDefault(A var1);

    protected abstract boolean isEnabled(A var1);

    protected abstract String getName(A var1);

    protected abstract String getDescription(A var1);

    protected abstract ActionIcon getIcon(A var1);

    public IntegerExpression actionsCountProperty() {
        return this.actionsCount;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean value) {
        this.expanded = value;
        this.contentPane.pseudoClassStateChanged(EXPANDED_PSEUDOCLASS, value);
        this.revalidate();
    }

    public final void populate(Collection<A> actions) {
        ArrayList<A> sortedActions = new ArrayList<A>(actions);
        Collections.sort(sortedActions, (action1, action2) -> {
            if (action1.getWeight() != action2.getWeight()) {
                return action1.getWeight() < action2.getWeight() ? -1 : 1;
            }
            return this.getName(action1).compareTo(this.getName(action2));
        });
        ArrayList<BarCell> links = new ArrayList<BarCell>(sortedActions.size());
        for (Action action : sortedActions) {
            boolean dflt = false;
            if (this.isDefault(action) && this.defaultAction == null) {
                this.defaultAction = action;
                dflt = true;
            }
            Hyperlink link = new Hyperlink();
            if (dflt) {
                link.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
            }
            link.setUserData((Object)action);
            link.setOnMouseClicked(evt -> {
                if (link.isDisabled()) {
                    return;
                }
                if (evt.getClickCount() != 1 || evt.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                evt.consume();
                link.requestFocus();
                this.execute((Control)link, action, evt.isAltDown());
            });
            link.setOnKeyPressed(evt -> {
                if (link.isDisabled()) {
                    return;
                }
                if (evt.getCode() != KeyCode.ENTER) {
                    return;
                }
                evt.consume();
                link.requestFocus();
                this.execute((Control)link, action, evt.isAltDown());
            });
            link.disabledProperty().addListener((obj, oldValue, newValue) -> {
                ImageView iv = (ImageView)link.getGraphic();
                if (iv == null) {
                    return;
                }
                ActionIcon icon = this.getIcon(action);
                iv.setImage(newValue != false ? icon.getDisabled() : icon.getStandard());
            });
            link.hoverProperty().addListener((obj, oldValue, newValue) -> {
                ImageView iv = (ImageView)link.getGraphic();
                if (iv == null) {
                    return;
                }
                ActionIcon icon = this.getIcon(action);
                iv.setImage(newValue != false ? icon.getHover() : icon.getStandard());
            });
            links.add(new BarCell(this, link, action));
        }
        this.contentPane.getChildren().setAll(links);
        this.revalidate();
    }

    public A getDefaultAction() {
        return this.defaultAction;
    }

    public void revalidate() {
        for (Node node : this.contentPane.getChildren()) {
            this.updateLinkDisplay((BarCell)node);
        }
    }

    @Override
    public void handleShortcut(KeyEvent event) {
        KeyBindings kb = KeyBindings.get();
        for (Node node : this.contentPane.getChildren()) {
            BarCell cell = (BarCell)node;
            KeyBindingAction kbAction = cell.getAction().getKeyBindingAction();
            if (kbAction == null || !kb.getKeyCombination(kbAction).match(event)) continue;
            event.consume();
            Hyperlink link = cell.getHyperlink();
            if (!link.isDisabled()) {
                link.requestFocus();
                this.execute((Control)link, cell.getAction(), false);
            }
            return;
        }
    }

    private void updateLinkDisplay(BarCell cell) {
        Object action = cell.getAction();
        Hyperlink link = cell.getHyperlink();
        UiUtil.setTooltip((Node)cell, this.getDescription(action));
        UiUtil.setTooltip((Node)link, this.getDescription(action));
        link.setDisable(!this.isEnabled(action));
        if (this.expanded) {
            link.setText(this.getName(action));
            link.setGraphic(null);
            return;
        }
        ActionIcon icon = this.getIcon(action);
        ImageView iv = new ImageView(link.isDisabled() ? icon.getDisabled() : icon.getStandard());
        link.setGraphic((Node)iv);
        link.setText(null);
    }

    private static class BarCell
    extends AnchorPane {
        private final Double ZERO = 0.0;
        private final Hyperlink hyperlink;
        private final A action;
        final /* synthetic */ ActionsPane this$0;

        BarCell(Hyperlink link, A a) {
            this.this$0 = var1_1;
            this.hyperlink = link;
            this.action = a;
            AnchorPane.setLeftAnchor((Node)this.hyperlink, (Double)this.ZERO);
            AnchorPane.setRightAnchor((Node)this.hyperlink, (Double)this.ZERO);
            this.getChildren().add((Object)this.hyperlink);
        }

        public Hyperlink getHyperlink() {
            return this.hyperlink;
        }

        public A getAction() {
            return this.action;
        }
    }
}

