/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.activity;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.common.fx.assets.ActivityItem;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;

public final class ActivityState<V extends Node, P> {
    static final int SAVE_DELAY = 1000;
    private String token;
    private final ActivityHandler<V, P> handler;
    private P parameters;
    private final StringProperty title = new SimpleStringProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final ObservableMutex mutex = new ObservableMutex();
    private boolean stateful;
    private V view;
    private ActivityItem asset;
    private final AtomicBoolean saveRequired = new AtomicBoolean();
    private ChangeListener<String> titleListener;
    private ChangeListener<String> descriptionListener;
    private String lockOwner;

    ActivityState(String token, String title, String description, ActivityHandler<V, P> handler, P parameters, boolean stateful) {
        this.token = Objects.requireNonNull(token);
        this.title.setValue(title);
        this.description.setValue(description);
        this.handler = handler;
        this.parameters = parameters;
        this.stateful = stateful;
    }

    ActivityState(ActivityHandler<V, P> h, ActivityItem a) throws Exception {
        this.token = a.getActivityToken();
        this.handler = h;
        this.stateful = true;
        this.parameters = this.handler.getSerializer().deserialize(a.getParameters());
        this.title.setValue(a.getTitle());
        this.description.setValue(a.getDescription());
        this.setAsset(a);
    }

    ActivityHandler<V, P> getHandler() {
        return this.handler;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String value) {
        if (MiscUtil.equals((Object)this.token, (Object)value)) {
            return;
        }
        this.token = Objects.requireNonNull(value);
        if (this.asset != null) {
            this.asset.setActivityToken(this.token);
        }
        this.scheduleSave(false);
    }

    public P getParameters() {
        return this.parameters;
    }

    public void setParameters(P parameters) {
        this.parameters = parameters;
        this.parametersChanged();
    }

    public void parametersChanged() {
        this.scheduleSave(false);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public ObservableMutex getMutex() {
        return this.mutex;
    }

    boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean value) {
        if (value == this.stateful) {
            return;
        }
        this.stateful = value;
        if (this.stateful) {
            this.scheduleSave(false);
        } else {
            this.delete(null);
        }
    }

    void delete(Runnable callback) {
        if (this.asset == null) {
            if (callback != null) {
                callback.run();
            }
            return;
        }
        this.saveRequired.set(false);
        ActivityItem toDelete = this.asset;
        this.setAsset(null);
        Notifications.get().submitTask(() -> {
            ((AssetService)RpcServiceManager.get().getService(AssetService.class)).delete(ServiceInvocationContext.get(), (BaseAsset)toDelete);
            if (callback != null) {
                FxUtil.submitToFxThread(callback::run);
            }
        }, this.mutex);
    }

    public boolean isLocked() {
        return this.asset == null ? false : this.asset.isLocked();
    }

    public String getLockOwner() {
        return this.isLocked() ? this.asset.getOwner() : this.lockOwner;
    }

    void setLockOwner(String value) {
        this.lockOwner = value;
    }

    V getView() {
        return this.view;
    }

    void setView(V value) {
        this.view = value;
    }

    ActivityItem getOrCreateAsset() {
        if (this.asset == null) {
            ActivityItem asset = this.searchAsset();
            if (asset == null) {
                asset = new ActivityItem();
                asset.setOwner(ServiceInvocationContext.get().getUser());
                asset.setActivityToken(this.token);
                asset.setHandlerId(this.handler.getId());
            }
            this.setAsset(asset);
        }
        return this.asset;
    }

    private ActivityItem searchAsset() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ActivityItem.Property.owner.name(), (Object)ServiceInvocationContext.get().getUser()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ActivityItem.Property.activityToken.name(), (Object)this.token));
        try {
            List activityItems = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), ActivityItem.class, query).getData();
            return (ActivityItem)CollectionUtil.head((Iterable)activityItems);
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
            return null;
        }
    }

    private void setAsset(ActivityItem value) {
        this.asset = value;
        if (this.asset != null) {
            if (this.titleListener == null) {
                this.titleListener = (s, o, n) -> this.scheduleSave(false);
                this.title.addListener(this.titleListener);
            }
            if (this.descriptionListener == null) {
                this.descriptionListener = (s, o, n) -> this.scheduleSave(false);
                this.description.addListener(this.descriptionListener);
            }
        } else {
            if (this.titleListener != null) {
                this.title.removeListener(this.titleListener);
                this.titleListener = null;
            }
            if (this.descriptionListener != null) {
                this.description.removeListener(this.descriptionListener);
                this.descriptionListener = null;
            }
        }
    }

    void scheduleSave(boolean force) {
        if (!this.stateful) {
            return;
        }
        if (this.asset == null && !force) {
            return;
        }
        this.saveRequired.set(true);
        if (force) {
            if (Platform.isFxApplicationThread()) {
                Notifications.get().submitTask(this::saveIfRequired, this.mutex);
            } else {
                this.saveIfRequired();
            }
        } else {
            Notifications.get().getScheduler().schedule(this::saveIfRequired, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    private void saveIfRequired() {
        if (!this.saveRequired.getAndSet(false)) {
            return;
        }
        try {
            this.save();
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    private void save() throws Exception {
        ActivityItem toSave = this.getOrCreateAsset();
        toSave.setTitle(TextUtil.truncate((String)((String)this.title.get()), (int)255));
        toSave.setDescription(TextUtil.truncate((String)((String)this.description.get()), (int)255));
        toSave.setParameters(this.handler.getSerializer().serialize(this.parameters));
        this.setAsset((ActivityItem)((AssetService)RpcServiceManager.get().getService(AssetService.class)).save(ServiceInvocationContext.get(), (BaseAsset)toSave));
    }

    public String toString() {
        return this.handler.getId() + ", " + this.token;
    }
}

