/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.assets.list;

import com.gridnine.xtrip.client.fx.core.assets.AssetHandler;
import com.gridnine.xtrip.client.fx.core.assets.AssetListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.ProjectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.list.ListPaneConfiguration;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.control.SelectionMode;

public class AssetsListPaneConfiguration
implements ListPaneConfiguration {
    public static final int DEFAULT_LIMIT = 100;
    private final AssetHandler<?> handler;
    private SelectionMode selectionMode;
    private boolean patternSearchEnabled;
    private final List<String> patternSearchFields = new ArrayList<String>();
    private boolean actionsEnabled;
    private int limit = 100;
    private final List<TableColumnSettings> columnsSettings = new ArrayList<TableColumnSettings>();
    private final List<TableColumnSettings> filterSettings = new ArrayList<TableColumnSettings>();
    private final Map<String, SortOrder> sorting = new LinkedHashMap<String, SortOrder>();
    private final List<SearchCriterion> searchCriterions = new ArrayList<SearchCriterion>();

    public AssetsListPaneConfiguration(AssetHandler<?> assetHandler) {
        this.handler = assetHandler;
    }

    @Override
    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode value) {
        this.selectionMode = value;
    }

    @Override
    public boolean isPatternSearchEnabled() {
        return this.patternSearchEnabled;
    }

    public void setPatternSearchEnabled(boolean value) {
        this.patternSearchEnabled = value;
    }

    public List<String> getPatternSearchFields() {
        return this.patternSearchFields;
    }

    @Override
    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    public void setActionsEnabled(boolean value) {
        this.actionsEnabled = value;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int value) {
        this.limit = value <= 0 ? 100 : value;
    }

    @Override
    public List<TableColumnSettings> getColumnsSettings() {
        return this.columnsSettings;
    }

    @Override
    public List<TableColumnSettings> getFiltersSettings() {
        return this.filterSettings;
    }

    @Override
    public List<ProjectionField> getProjections() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, SortOrder> getSorting() {
        return this.sorting;
    }

    public AssetHandler<?> getHandler() {
        return this.handler;
    }

    public List<SearchCriterion> getSearchCriterions() {
        return this.searchCriterions;
    }

    public void applyParameters(AssetListParameters parameters) {
        this.columnsSettings.addAll(parameters.getColumns());
        this.filterSettings.addAll(parameters.getFilters());
        this.searchCriterions.addAll(parameters.getSearchCriterions());
        this.patternSearchFields.addAll(parameters.getPatternSearchFields());
    }
}

