/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.dialogs;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class DialogPane
extends StackPane {
    private final Map<Dialog, DialogLayer> layers = new IdentityHashMap<Dialog, DialogLayer>();

    public DialogPane() {
        this.getStyleClass().add((Object)"xtrip-dialog-pane");
        this.setAlignment(Pos.TOP_CENTER);
        this.setVisible(false);
    }

    private DialogLayer createLayer(boolean expand) {
        DialogLayer layer = new DialogLayer();
        layer.shadowPane = new StackPane();
        layer.shadowPane.getStyleClass().add((Object)"xtrip-dialog-pane-shadow");
        layer.dialogArea = new BorderPane();
        layer.dialogArea.getStyleClass().add((Object)"xtrip-dialog-pane-container-pane");
        if (expand) {
            layer.dialogParent = layer.dialogArea;
            layer.dialogArea.setTop((Node)this.createVerticalGap());
            layer.dialogArea.setBottom((Node)this.createVerticalGap());
            layer.dialogArea.setLeft((Node)this.createHorisontalGap());
            layer.dialogArea.setRight((Node)this.createHorisontalGap());
        } else {
            Group group = new Group();
            group.getChildren().add((Object)layer.dialogArea);
            layer.dialogParent = group;
        }
        return layer;
    }

    void show(Dialog dialog, Pane dialogPane) {
        DialogLayer layer = this.createLayer(dialog.isExpandToParent());
        layer.dialogArea.setCenter((Node)dialogPane);
        this.layers.put(dialog, layer);
        this.setVisible(true);
        this.getChildren().addAll((Object[])new Node[]{layer.shadowPane, layer.dialogParent});
        FxUtil.submitToFxThread(() -> {
            Stage stage;
            if (this.getScene() != null && !(stage = (Stage)this.getScene().getWindow()).isFocused()) {
                stage.requestFocus();
                stage.toFront();
            }
            dialogPane.requestFocus();
        });
    }

    void hide(Dialog dialog) {
        DialogLayer layer = this.layers.remove(dialog);
        if (layer == null) {
            return;
        }
        this.getChildren().removeAll((Object[])new Node[]{layer.dialogParent, layer.shadowPane});
        if (this.getChildren().isEmpty()) {
            this.setVisible(false);
        }
    }

    Collection<Dialog> getOpened() {
        return this.layers.keySet();
    }

    private Pane createHorisontalGap() {
        StackPane pane = new StackPane();
        pane.getStyleClass().add((Object)"xtrip-horisontal-gap");
        return pane;
    }

    private Pane createVerticalGap() {
        StackPane pane = new StackPane();
        pane.getStyleClass().add((Object)"xtrip-vertical-gap");
        return pane;
    }

    class DialogLayer {
        StackPane shadowPane;
        BorderPane dialogArea;
        Parent dialogParent;

        DialogLayer() {
        }
    }
}

