/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;

public interface RootEntityHandler<E extends BaseEntity, S>
extends RegistryItem<RootEntityHandler<?, ?>> {
    public static final RegistryItemType<RootEntityHandler<?, ?>> TYPE = new RegistryItemType("ROOT-ENTITY-HANDLER");

    public static RootEntityHandler<?, ?> forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    public static <E extends BaseEntity> RootEntityHandler<E, ?> forEntityClass(Class<E> entityClass) {
        return RootEntityHandler.forEntityClass(entityClass.getName());
    }

    public static <E extends BaseEntity> RootEntityHandler<E, ?> forEntityClass(String entityClassName) {
        for (RootEntityHandler<?, ?> handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (!handler.getEntityClass().getName().equals(entityClassName)) continue;
            return handler;
        }
        return null;
    }

    public static String format(RootEntityHandler<?, ?> handler) {
        String result = ClientRegistry.get().getResourceFor(handler, "name");
        if (!TextUtil.isBlank((String)result)) {
            return result;
        }
        EntityType ett = (EntityType)MetaRegistry.get().getEntities().get(handler.getEntityClass().getName());
        result = ett == null ? handler.getId() : ett.getDisplayName();
        return TextUtil.isBlank((String)result) ? handler.getId() : result;
    }

    @Override
    default public RegistryItemType<RootEntityHandler<?, ?>> getType() {
        return TYPE;
    }

    @Override
    default public String getId() {
        return this.getEntityClass().getName();
    }

    default public String format(EntityContainer<E> ctr) {
        return ctr.getEntity().toString();
    }

    public Class<E> getEntityClass();

    public Class<S> getSupplementClass();

    public Class<? extends EntityIndex<?>> getStandardIndexClass();

    public ViewController<?, DataTransferPackage<E, S>> createEditorController(boolean var1);

    default public List<RootEntityEditorInterceptor<E, S>> getEditorInterceptors() {
        return Collections.emptyList();
    }

    public boolean isAvaibleInConfiguration();
}

