/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.list;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.ProjectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.list.ListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.control.SelectionMode;

public class IndexListPaneConfiguration<E extends BaseEntity, I extends EntityIndex<E>>
implements ListPaneConfiguration {
    public static final int DEFAULT_LIMIT = 100;
    private final Class<I> indexClass;
    private final List<TableColumnSettings> columnsSettings = new ArrayList<TableColumnSettings>();
    private final List<TableColumnSettings> filtersSettings = new ArrayList<TableColumnSettings>();
    private final List<ProjectionField> projections = new ArrayList<ProjectionField>();
    private final Map<String, SortOrder> sorting = new LinkedHashMap<String, SortOrder>();
    private final List<SearchCriterion> searchCriterions = new ArrayList<SearchCriterion>();
    private final List<RestrictionGroup> restrictions = new ArrayList<RestrictionGroup>();
    private final List<String> patternSearchFields = new ArrayList<String>();
    private SelectionMode selectionMode;
    private boolean patternSearchEnabled;
    private boolean actionsEnabled;
    private int limit = 100;

    private static List<TableColumnSettings> prepareColumnSettings(IndexType indexType, List<TableColumnSettings> list) {
        ArrayList<TableColumnSettings> result = new ArrayList<TableColumnSettings>(list.size());
        for (TableColumnSettings origSett : list) {
            TableColumnSettings newSett = new TableColumnSettings();
            newSett.setId(origSett.getId());
            newSett.setDisplayName(origSett.getDisplayName());
            newSett.setIcon(origSett.getIcon());
            newSett.setPrefWidth(origSett.getPrefWidth());
            newSett.setType(origSett.getType());
            newSett.setRenderer(origSett.getRenderer());
            IndexProperty prop = (IndexProperty)indexType.getProperties().get(newSett.getId());
            if (prop != null) {
                if (newSett.getType() == null) {
                    newSett.setType(prop.getType());
                }
                if (newSett.getDisplayName() == null) {
                    newSett.setDisplayName(prop.getDisplayName());
                }
                if (newSett.getRenderer() == null) {
                    if ("java.util.Date".equals(newSett.getType()) && !TextUtil.isBlank((String)prop.getFormat())) {
                        newSett.setRenderer(StandardRenderers.DATE_TIME);
                    } else if ("time".equalsIgnoreCase(prop.getFormat())) {
                        newSett.setRenderer(StandardRenderers.TIME);
                    } else if (prop.isInfinitable()) {
                        newSett.setRenderer(StandardRenderers.INFINITABLE_DECIMAL);
                    } else {
                        newSett.setRenderer(StandardRenderers.guessFor(newSett.getType()));
                    }
                }
                newSett.setSortable(prop.isSearchable() || prop.isFilterable());
            } else {
                IndexCollection coll = (IndexCollection)indexType.getCollections().get(newSett.getId());
                if (coll != null) {
                    if (newSett.getType() == null) {
                        newSett.setType(coll.getElementType());
                    }
                    if (newSett.getDisplayName() == null) {
                        newSett.setDisplayName(coll.getDisplayName());
                    }
                    if (newSett.getRenderer() == null) {
                        if ("java.util.Date".equals(newSett.getType()) && !TextUtil.isBlank((String)coll.getFormat())) {
                            newSett.setRenderer(StandardRenderers.DATE_TIME);
                        } else if ("time".equalsIgnoreCase(coll.getFormat())) {
                            newSett.setRenderer(StandardRenderers.TIME);
                        } else {
                            Renderer renderer = StandardRenderers.guessFor(newSett.getType());
                            if (renderer == StandardRenderers.GENERIC) {
                                renderer = StandardRenderers.GENERIC_SORTING;
                            }
                            newSett.setRenderer(renderer);
                        }
                    }
                    newSett.setSortable(false);
                }
            }
            result.add(newSett);
        }
        return result;
    }

    private static List<ProjectionField> prepareProjections(IndexType indexType, List<ProjectionField> list) {
        ArrayList<ProjectionField> result = new ArrayList<ProjectionField>();
        for (ProjectionField field : list) {
            IndexProperty prop;
            ProjectionField newField = new ProjectionField();
            newField.setId(field.getId());
            newField.setDisplayName(field.getDisplayName());
            newField.setOperation(field.getOperation());
            if (newField.getDisplayName() == null && (prop = (IndexProperty)indexType.getProperties().get(newField.getId())) != null) {
                newField.setDisplayName(prop.getDisplayName());
            }
            result.add(newField);
        }
        return result;
    }

    public IndexListPaneConfiguration(Class<I> it) {
        this.indexClass = it;
    }

    public Class<I> getIndexType() {
        return this.indexClass;
    }

    @Override
    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode value) {
        this.selectionMode = value;
    }

    @Override
    public boolean isPatternSearchEnabled() {
        return this.patternSearchEnabled;
    }

    public void setPatternSearchEnabled(boolean value) {
        this.patternSearchEnabled = value;
    }

    @Override
    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    public void setActionsEnabled(boolean value) {
        this.actionsEnabled = value;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int value) {
        this.limit = value <= 0 ? 100 : value;
    }

    @Override
    public List<TableColumnSettings> getColumnsSettings() {
        return this.columnsSettings;
    }

    @Override
    public List<TableColumnSettings> getFiltersSettings() {
        return this.filtersSettings;
    }

    @Override
    public List<ProjectionField> getProjections() {
        return this.projections;
    }

    @Override
    public Map<String, SortOrder> getSorting() {
        return this.sorting;
    }

    public List<SearchCriterion> getSearchCriterions() {
        return this.searchCriterions;
    }

    public List<RestrictionGroup> getRestrictions() {
        return this.restrictions;
    }

    public List<String> getPatternSearchFields() {
        return this.patternSearchFields;
    }

    public void applyParameters(IndexListParameters<E, I> parameters) {
        IndexType indexType = MetaRegistryHelper.getIndexType((String)this.indexClass.getTypeName());
        this.columnsSettings.clear();
        this.columnsSettings.addAll(IndexListPaneConfiguration.prepareColumnSettings(indexType, parameters.getColumns()));
        this.filtersSettings.clear();
        this.filtersSettings.addAll(IndexListPaneConfiguration.prepareColumnSettings(indexType, parameters.getFilters()));
        this.projections.clear();
        this.projections.addAll(IndexListPaneConfiguration.prepareProjections(indexType, parameters.getProjections()));
        this.sorting.clear();
        this.sorting.putAll(parameters.getSortings());
        this.searchCriterions.clear();
        this.searchCriterions.addAll(parameters.getSearchCriterions());
        this.restrictions.clear();
        this.restrictions.addAll(parameters.getRestrictions());
        this.patternSearchFields.clear();
        this.patternSearchFields.addAll(parameters.getPatternSearchFields());
    }
}

