/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.BaseCollectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class CollectionFieldEntityReference<E>
extends BaseCollectionField<E> {
    private final TableWidgetController<TableWidget<ValueHolder<EntityReference<BaseEntity>>>, ValueHolder<EntityReference<BaseEntity>>> controller;

    CollectionFieldEntityReference(Class<E> entityClass, EntityCollection coll) throws Exception {
        super(entityClass, coll);
        final TableWidget widget = new TableWidget(false);
        widget.setItemsProvider(() -> new ValueHolder());
        if (List.class.getName().equals(coll.getType())) {
            widget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        }
        ArrayList columns = new ArrayList();
        EntityBoxWidgetColumn column = new EntityBoxWidgetColumn(XSHelper.getClass((String)coll.getElementType()), vh -> (EntityReference)vh.get(), (vh, value) -> vh.set(value));
        column.setId("value");
        columns.add(column);
        widget.setColumns(columns);
        this.controller = new TableWidgetController<TableWidget<ValueHolder<EntityReference<BaseEntity>>>, ValueHolder<EntityReference<BaseEntity>>>(){

            @Override
            public TableWidget<ValueHolder<EntityReference<BaseEntity>>> getView() {
                return widget;
            }
        };
    }

    @Override
    void buildUI(List<GridCell<?>> cells, String label) {
        ((TableWidget)this.controller.getView()).getColumn("value").setFieldName(label);
        cells.add(GridCell.NEW_ROW_MARKER);
        GridCell cell = new GridCell(label, this.controller.getView());
        cell.setColSpan(Integer.MAX_VALUE);
        cells.add(cell);
    }

    @Override
    void readData(E entity) {
        this.controller.readData(((Collection)ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id)).stream().map(val -> new ValueHolder<EntityReference>((EntityReference)val)).collect(Collectors.toList()));
    }

    @Override
    void writeData(E entity) {
        ArrayList list = new ArrayList();
        this.controller.writeData(list);
        Collection value = (Collection)ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id);
        value.clear();
        for (ValueHolder vh : list) {
            if (vh.get() == null) continue;
            value.add(vh.get());
        }
    }

    @Override
    void setReadonly(boolean readonly) {
        this.controller.setReadonly(readonly);
    }

    @Override
    boolean isDataChanged() {
        return this.controller.isDataChanged();
    }

    @Override
    void setNotEditable(boolean notEditable) {
        ((TableWidget)this.controller.getView()).getViewState().setNotEditable(notEditable);
    }

    @Override
    void setAclNotEditable(boolean aclNotEditable) {
        ((TableWidget)this.controller.getView()).getViewState().setAclNotEditable(aclNotEditable);
    }
}

