/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;

class MetadataContext {
    private final Map<String, List<IndexType>> indexes = new HashMap<String, List<IndexType>>();
    private final BiPredicate<EntityType, String> fieldFilter;

    MetadataContext(BiPredicate<EntityType, String> filter) {
        this.fieldFilter = filter;
    }

    BiPredicate<EntityType, String> getFieldFilter() {
        return this.fieldFilter;
    }

    String getLabel(EntityType entityType, BaseMetaElement elm) {
        String result = elm.getDisplayName();
        if (result == null || result.contains("com.gridnine.")) {
            for (IndexType index : this.getIndexes(entityType)) {
                IndexProperty indexProperty = (IndexProperty)index.getProperties().get(elm.getId());
                if (indexProperty != null) {
                    return indexProperty.getDisplayName();
                }
                IndexCollection collProperty = (IndexCollection)index.getCollections().get(elm.getId());
                if (collProperty == null) continue;
                return collProperty.getDisplayName();
            }
        }
        if (result != null && result.contains("com.gridnine.")) {
            if (result.endsWith(".name")) {
                result = result.substring(0, result.length() - 5);
            }
            result = result.substring(result.lastIndexOf(46) + 1);
        }
        return result == null ? elm.getId() : result;
    }

    private List<IndexType> getIndexes(EntityType entityType) {
        List<IndexType> result = this.indexes.get(entityType.getId());
        if (result != null) {
            return result;
        }
        result = new ArrayList<IndexType>();
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (IndexType item : metaRegistry.getIndexes().values()) {
            if (!MetaRegistryHelper.isAssignableFrom((String)item.getEntityId(), (EntityType)entityType)) continue;
            result.add(item);
        }
        if (result.size() > 1) {
            Collections.sort(result, new Comparator<IndexType>(){

                @Override
                public int compare(IndexType o1, IndexType o2) {
                    boolean a1 = this.isAbstract(o1);
                    boolean a2 = this.isAbstract(o2);
                    if (a1) {
                        return a2 ? 0 : 1;
                    }
                    return a2 ? -1 : 0;
                }

                private boolean isAbstract(IndexType o1) {
                    return BaseEntity.class.getName().equals(o1.getEntityId()) || ((EntityType)MetaRegistry.get().getEntities().get(o1.getEntityId())).isAbstract();
                }
            });
        }
        this.indexes.put(entityType.getId(), result);
        return result;
    }
}

