/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.BasePropertyField;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.util.Date;
import java.util.List;

class PropertyFieldDate<E>
extends BasePropertyField<E> {
    private final DateValueWidget widget = new DateValueWidget(false);
    private Date value;

    PropertyFieldDate(Class<E> entityClass, Property prop) throws Exception {
        super(entityClass, prop);
    }

    @Override
    void buildUI(List<GridCell<?>> cells, String label) {
        cells.add(new GridCell<DateValueWidget>(label, this.widget));
    }

    @Override
    void readData(E entity) {
        this.value = (Date)ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id);
        this.widget.setValue(DateUtils.asLocalDate(this.value));
    }

    @Override
    void writeData(E entity) {
        this.value = DateUtils.asDate(this.widget.getValue());
        ReflectionUtil.setValue((Class)this.cls, entity, (String)this.id, (Object)this.value);
    }

    @Override
    void setReadonly(boolean readonly) {
        this.widget.getViewState().setReadonly(readonly);
    }

    @Override
    boolean isDataChanged() {
        return !MiscUtil.equals((Object)this.value, (Object)this.widget.getValue());
    }

    @Override
    void setNotEditable(boolean notEditable) {
        this.widget.getViewState().setNotEditable(notEditable);
    }

    @Override
    void setAclNotEditable(boolean aclNotEditable) {
        this.widget.getViewState().setAclNotEditable(aclNotEditable);
    }
}

