/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.BasePropertyField;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.util.List;

class PropertyFieldUnsupported<E>
extends BasePropertyField<E> {
    private final TextFieldWidget widget = new TextFieldWidget(true);
    private final String type;

    PropertyFieldUnsupported(Class<E> entityClass, Property prop) throws Exception {
        super(entityClass, prop);
        this.widget.getViewState().setNotEditable(true);
        this.type = prop.getType();
    }

    @Override
    void buildUI(List<GridCell<?>> cells, String label) {
        GridCell<TextFieldWidget> cell = new GridCell<TextFieldWidget>(label, this.widget);
        cell.setHelp(() -> new QuickHelp(String.format("<html>Unsupported property field of type <b>%s</b>", this.type)));
        cells.add(cell);
    }

    @Override
    void readData(E entity) {
        this.widget.setValue((String)StandardRenderers.GENERIC.apply(ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id)));
    }

    @Override
    void writeData(E entity) {
    }

    @Override
    void setReadonly(boolean readonly) {
    }

    @Override
    boolean isDataChanged() {
        return false;
    }

    @Override
    void setNotEditable(boolean notEditable) {
    }

    @Override
    void setAclNotEditable(boolean aclNotEditable) {
    }
}

