/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.raw;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.util.List;
import javafx.scene.layout.StackPane;

public class RawEntityEditor<E extends BaseEntity>
extends StackPane {
    private final TextAreaWidget widget = new TextAreaWidget(false);
    private String content;

    public static <E extends BaseEntity> ViewController<RawEntityEditor<E>, E> createEntityController(Class<E> cls) {
        return new ViewController<RawEntityEditor<E>, E>(){
            private final RawEntityEditor<E> editor = new RawEntityEditor();
            private E data;
            private boolean readonly;

            @Override
            public RawEntityEditor<E> getView() {
                return this.editor;
            }

            @Override
            public E getData() {
                return this.data;
            }

            @Override
            public void readData(E model) {
                this.data = model;
                this.editor.readData(this.data);
            }

            @Override
            public void writeData(E model) {
                this.data = model;
                this.editor.writeData(this.data);
            }

            @Override
            public boolean isReadonly() {
                return this.readonly;
            }

            @Override
            public void setReadonly(boolean value) {
                this.readonly = value;
                this.editor.setReadonly(this.readonly);
            }

            @Override
            public void setNotEditable(boolean value) {
                this.editor.setNotEditable(value);
            }

            @Override
            public void setAclNotEditable(boolean aclNotEditable) {
                this.editor.setAclNotEditable(aclNotEditable);
            }

            @Override
            public boolean isDataChanged() {
                return this.editor.isDataChanged();
            }

            @Override
            public void validateData(List<Message> messages) {
            }
        };
    }

    public static <E extends BaseEntity> ViewController<RawEntityEditor<E>, EntityContainer<E>> createContainerController(Class<E> cls) {
        return new ViewController<RawEntityEditor<E>, EntityContainer<E>>(){
            private final RawEntityEditor<E> editor = new RawEntityEditor();
            private EntityContainer<E> data;
            private boolean readonly;

            @Override
            public RawEntityEditor<E> getView() {
                return this.editor;
            }

            @Override
            public EntityContainer<E> getData() {
                return this.data;
            }

            @Override
            public void readData(EntityContainer<E> model) {
                this.data = model;
                this.editor.readData(model.getEntity());
            }

            @Override
            public void writeData(EntityContainer<E> model) {
                this.data = model;
                this.editor.writeData(model.getEntity());
            }

            @Override
            public boolean isReadonly() {
                return this.readonly;
            }

            @Override
            public void setReadonly(boolean value) {
                this.readonly = value;
                this.editor.setReadonly(value);
            }

            @Override
            public void setNotEditable(boolean value) {
                this.editor.setNotEditable(value);
            }

            @Override
            public void setAclNotEditable(boolean aclNotEditable) {
                this.editor.setAclNotEditable(aclNotEditable);
            }

            @Override
            public boolean isDataChanged() {
                return this.editor.isDataChanged();
            }

            @Override
            public void validateData(List<Message> messages) {
            }
        };
    }

    RawEntityEditor() {
        this.widget.setMonospace(true);
        this.getChildren().add((Object)this.widget);
    }

    protected void readData(E model) {
        try {
            this.content = XSUtil.toString(model).replace("\r\n", "\n");
            this.widget.setValue(this.content);
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    protected void writeData(E model) {
        try {
            this.content = this.widget.getValue();
            XUtil.fromString((String)this.content, model);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.XML_parsing_error, (Throwable)e, (Object[])new Object[0]));
        }
    }

    protected void setReadonly(boolean readonly) {
        this.widget.getViewState().setReadonly(readonly);
    }

    protected void setNotEditable(boolean notEditable) {
        this.widget.getViewState().setNotEditable(notEditable);
    }

    protected void setAclNotEditable(boolean aclNotEditable) {
        this.widget.getViewState().setAclNotEditable(aclNotEditable);
    }

    protected boolean isDataChanged() {
        return !MiscUtil.equals((Object)this.content, (Object)this.widget.getValue());
    }
}

