/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.event;

import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventType;
import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

public final class EventBus
implements Disposable {
    final BlockingQueue<Event<?>> eventQueue = new LinkedBlockingQueue();
    private final Thread workerThread;
    private final Thread cleanerThread;
    private final ConcurrentMap<EventType<?>, List<WeakReference<Consumer<?>>>> handlers = new ConcurrentHashMap();

    public static EventBus get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (EventBus)Environment.getPublished(EventBus.class);
    }

    public EventBus() {
        this.workerThread = new Thread("EventBus-worker"){

            @Override
            public void run() {
                try {
                    do {
                        EventBus.this.processEvent(EventBus.this.eventQueue.take());
                    } while (!this.isInterrupted());
                }
                catch (InterruptedException e) {}
            }
        };
        this.workerThread.setDaemon(true);
        this.workerThread.start();
        this.cleanerThread = new Thread("EventBus-cleaner"){

            @Override
            public void run() {
                try {
                    do {
                        2.sleep(60000L);
                        EventBus.this.clean();
                    } while (!this.isInterrupted());
                }
                catch (InterruptedException e) {}
            }
        };
        this.cleanerThread.setDaemon(true);
        this.cleanerThread.start();
    }

    public void dispose() {
        this.workerThread.interrupt();
        this.cleanerThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Event<E>> void subscribe(EventType<E> type, Consumer<E> subscriber) {
        List<WeakReference<Consumer<E>>> list = (ArrayList<WeakReference<Consumer<E>>>)this.handlers.get(type);
        if (list == null) {
            list = new ArrayList<WeakReference<Consumer<E>>>();
            list.add(new WeakReference<Consumer<E>>(subscriber));
            List prev = this.handlers.putIfAbsent(type, list);
            if (prev == null) {
                return;
            }
            list = prev;
        }
        ArrayList<WeakReference<Consumer<E>>> arrayList = list;
        synchronized (arrayList) {
            list.add(new WeakReference<Consumer<E>>(subscriber));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Object subscriber) {
        for (Map.Entry entry : this.handlers.entrySet()) {
            List list;
            List list2 = list = (List)entry.getValue();
            synchronized (list2) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Consumer consumer = (Consumer)((WeakReference)it.next()).get();
                    if (consumer != null && consumer != subscriber) continue;
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscribers(EventType<?> type) {
        ArrayList list = (ArrayList)this.handlers.get(type);
        if (list == null || list.isEmpty()) {
            return false;
        }
        ArrayList arrayList = list;
        synchronized (arrayList) {
            list = new ArrayList(list);
        }
        for (WeakReference ref : list) {
            if (ref.get() == null) continue;
            return true;
        }
        return false;
    }

    public void publishAsync(Event<?> event) {
        this.eventQueue.add(event);
    }

    public void publishSync(Event<?> event) {
        this.processEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(Event<?> event) {
        ArrayList list = (ArrayList)this.handlers.get(event.getType());
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList arrayList = list;
        synchronized (arrayList) {
            list = new ArrayList(list);
        }
        for (WeakReference ref : list) {
            if (Thread.currentThread().isInterrupted()) break;
            Consumer consumer = (Consumer)ref.get();
            if (consumer == null) continue;
            consumer.accept(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean() {
        for (Map.Entry entry : this.handlers.entrySet()) {
            List list;
            List list2 = list = (List)entry.getValue();
            synchronized (list2) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    if (((WeakReference)it.next()).get() != null) continue;
                    it.remove();
                }
            }
        }
    }

    private static class Holder {
        public static final EventBus INSTANCE = (EventBus)Environment.getPublished(EventBus.class);

        private Holder() {
        }
    }
}

