/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.factory;

import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.factory.ProxyFactoryTool;
import com.gridnine.xtrip.common.Environment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

class ToolsRecent {
    private static final int LIMIT = 6;
    private static volatile ToolsRecent instance;
    private final ArrayList<FactoryTool> data = new ArrayList(6);

    static synchronized ToolsRecent get() {
        if (instance == null) {
            instance = new ToolsRecent();
            instance.load();
        }
        return instance;
    }

    private static File getDataFile() {
        File file = new File(Environment.getDataFolder(), "settings/factory-tools-recent.dat");
        return file;
    }

    private ToolsRecent() {
    }

    void onExecute(FactoryTool tool) {
        Iterator<FactoryTool> it = this.data.iterator();
        while (it.hasNext()) {
            FactoryTool ft = it.next();
            if (!ft.getUid().equals(tool.getUid())) continue;
            it.remove();
        }
        if (this.data.size() >= 6) {
            this.data.remove(0);
        }
        this.data.add(tool);
        this.save();
    }

    void remove(String toolUid) {
        Iterator<FactoryTool> it = this.data.iterator();
        while (it.hasNext()) {
            if (!it.next().getUid().equals(toolUid)) continue;
            it.remove();
        }
        this.save();
    }

    List<FactoryTool> getRecent() {
        return new ArrayList<FactoryTool>(this.data);
    }

    private void load() {
        String prefix;
        String uid;
        File file = ToolsRecent.getDataFile();
        if (!file.isFile()) {
            return;
        }
        Properties props = new Properties();
        try (BufferedReader in2 = Files.newBufferedReader(file.toPath());){
            props.load(in2);
        }
        catch (Exception in2) {
            // empty catch block
        }
        int idx = 0;
        while ((uid = props.getProperty((prefix = idx + ".") + "uid")) != null) {
            FactoryToolCategory category = FactoryToolCategory.forId(props.getProperty(prefix + "category"));
            if (category == null) {
                category = FactoryToolCategory.forId("OTHER");
            }
            this.data.add(new ProxyFactoryTool(uid, props.getProperty(prefix + "name"), category, Boolean.parseBoolean(props.getProperty(prefix + "auxiliary", "false"))));
            ++idx;
        }
    }

    private void save() {
        File file = ToolsRecent.getDataFile();
        file.getParentFile().mkdirs();
        Properties props = new Properties();
        FactoryTool[] arr = this.data.toArray(new FactoryTool[this.data.size()]);
        for (int i = 0; i < arr.length; ++i) {
            FactoryTool tool = arr[i];
            String prefix = i + ".";
            props.setProperty(prefix + "uid", tool.getUid());
            props.setProperty(prefix + "name", tool.getName() == null ? "" : tool.getName());
            if (tool.getCategory() != null) {
                props.setProperty(prefix + "category", tool.getCategory().getId());
            }
            props.setProperty(prefix + "auxiliary", Boolean.toString(tool.isAuxiliary()));
        }
        try (BufferedWriter out = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            props.store(out, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

