/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.gen.CodeGenHelper;
import com.gridnine.xtrip.client.fx.core.gen.Widgets;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import java.util.ArrayList;
import java.util.stream.Collectors;

final class CardsContainerGenerator {
    static void generate(JavaWriter writer, GenerationContext ctx, UiCardsContainer ctr) throws Exception {
        writer.beginCompilationUnit(ctx.getOutFolder(), ctr.getId());
        writer.doc("Cards container generated from UI metadata:\n<dl><dt>view ID</dt><dd>%s</dd>\n<dt>model</dt><dd>{@link %s}</dd>\n<dt>controller</dt><dd>{@link %1$sController}</dd>\n<dt>sources</dt><dd>%s</dd></dl>", new Object[]{ctr.getId(), ctr.getModel().getClassName(), ctx.getUiMetaRegistry().getSources((BaseUiMetaElement)ctr).stream().map(url -> {
            String result = url.toExternalForm();
            int p = result.indexOf("plugins/");
            return p == -1 ? result : result.substring(p);
        }).collect(Collectors.joining("<br>"))});
        if (ctr.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        String className = GenUtil.getSimpleClassName((String)ctr.getId());
        writer.beginBlock("public class %s extends %s", new Object[]{className, CardsContainer.class.getName()});
        CardsContainerGenerator.generateConstructor(writer, ctx, ctr);
        CodeGenHelper.generateProperties(writer, ctr.getProperties());
        CardsContainerGenerator.generateFields(writer, ctx, ctr);
        CardsContainerGenerator.generateMethods(writer, ctx, ctr);
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private static void generateFields(JavaWriter writer, GenerationContext ctx, UiCardsContainer ctr) throws Exception {
        for (UiCardsContainer.Card card : ctr.getCards()) {
            String contentType;
            UiElement payload = card.getPayload();
            if (payload instanceof UiContainerReference) {
                UiContainerReference ref = (UiContainerReference)payload;
                contentType = ref.getId();
            } else {
                Widgets widget = Widgets.getFor((BaseUiWidget)payload);
                contentType = widget.getWidgetClass(ctx, (BaseUiWidget)payload);
            }
            String cardType = String.format("%s<%s>", Card.class.getName(), contentType);
            writer.code("private final %s %sCard;", new Object[]{cardType, card.getId()});
            writer.beginBlock("public %s get%sCard()", new Object[]{cardType, GenUtil.capitalize((String)card.getId())});
            writer.code("return %sCard;", new Object[]{card.getId()});
            writer.endBlock();
            writer.beginBlock("%s get%sNode()", new Object[]{contentType, GenUtil.capitalize((String)card.getId())});
            writer.code("return %sCard.getContent();", new Object[]{card.getId()});
            writer.endBlock();
            writer.blank();
        }
    }

    private static void generateMethods(JavaWriter writer, GenerationContext ctx, UiCardsContainer ctr) throws Exception {
    }

    private static void generateConstructor(JavaWriter writer, GenerationContext ctx, UiCardsContainer ctr) throws Exception {
        writer.beginBlock("public %s(boolean readonly)", new Object[]{GenUtil.getSimpleClassName((String)ctr.getId())});
        writer.code("%s<%s<?>> cards = new %1$s<>(%s);", new Object[]{ArrayList.class.getName(), Card.class.getName(), ctr.getCards().size()});
        for (UiCardsContainer.Card card : ctr.getCards()) {
            writer.beginBlock();
            CodeGenHelper.genLabelVar(card.getCaption(), writer, "caption");
            UiElement payload = card.getPayload();
            if (payload instanceof UiContainerReference) {
                UiContainerReference ref = (UiContainerReference)payload;
                writer.code("%s contentNode = new %1$s(readonly);", new Object[]{ref.getId()});
            } else {
                Widgets widget = Widgets.getFor((BaseUiWidget)payload);
                writer.code("%s contentNode;", new Object[]{widget.getWidgetClass(ctx, (BaseUiWidget)payload)});
                widget.generateContainerFieldInitializer(writer, ctx, (BaseUiWidget)payload, "content");
            }
            writer.code("%sCard = new %s<>(\"%1$s\", %s.Style.%s, caption, contentNode);", new Object[]{card.getId(), Card.class.getName(), UiCardsContainer.class.getName(), card.getStyle().name()});
            CodeGenHelper.genSetHelp(card.getHelp(), writer, card.getId() + "Card");
            if (card.isHidden()) {
                writer.code("%sCard.setHidden(%s);", new Object[]{card.getId(), String.valueOf(card.isHidden())});
            }
            writer.code("cards.add(%sCard);", new Object[]{card.getId()});
            writer.endBlock();
        }
        writer.code("getCards().addAll(cards);", new Object[0]);
        writer.endBlock();
    }

    private CardsContainerGenerator() {
    }
}

