/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.gen.CodeGenHelper;
import com.gridnine.xtrip.client.fx.core.gen.Widgets;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.BaseCell;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainerColumn;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.ComplexCell;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.SimpleCell;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiCellsContainer;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.model.Xeption;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javafx.geometry.Pos;
import javafx.scene.layout.GridPane;

class CellsContainerGenerator {
    static void generate(JavaWriter writer, GenerationContext ctx, UiCellsContainer ctr) throws Exception {
        writer.beginCompilationUnit(ctx.getOutFolder(), ctr.getId());
        writer.doc("Cells container generated from UI metadata:\n<dl><dt>view ID</dt><dd>%s</dd>\n<dt>model</dt><dd>{@link %s}</dd>\n<dt>controller</dt><dd>{@link %1$sController}</dd>\n<dt>sources</dt><dd>%s</dd></dl>", new Object[]{ctr.getId(), ctr.getModel().getClassName(), ctx.getUiMetaRegistry().getSources((BaseUiMetaElement)ctr).stream().map(url -> {
            String result = url.toExternalForm();
            int p = result.indexOf("plugins/");
            return p == -1 ? result : result.substring(p);
        }).collect(Collectors.joining("<br>"))});
        if (ctr.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public class %s extends %s", new Object[]{GenUtil.getSimpleClassName((String)ctr.getId()), CellsContainer.class.getName()});
        CellsContainerGenerator.generateConstructor(writer, ctx, ctr);
        CodeGenHelper.generateProperties(writer, ctr.getProperties());
        CellsContainerGenerator.generateFields(writer, ctx, ctr);
        CellsContainerGenerator.generateMethods(writer, ctx, ctr);
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private static void generateConstructor(JavaWriter writer, GenerationContext ctx, UiCellsContainer ctr) throws Exception {
        writer.beginBlock("public %s(boolean readonly)", new Object[]{GenUtil.getSimpleClassName((String)ctr.getId())});
        writer.beginBlock();
        writer.code("%s<%s> columns = new %1$s<>();", new Object[]{ArrayList.class.getName(), CellsContainerColumn.class.getName()});
        for (UiCellsContainer.Column column : ctr.getColumns()) {
            if (column.getPrefWidth() == null) {
                writer.code("columns.add(new %s());", new Object[]{CellsContainerColumn.class.getName()});
                continue;
            }
            writer.code("columns.add(new %s(Double.valueOf(%s)));", new Object[]{CellsContainerColumn.class.getName(), column.getPrefWidth().toString()});
        }
        writer.code("getColumns().addAll(columns);", new Object[0]);
        writer.endBlock();
        writer.beginBlock();
        writer.code("%s<%s> cells = new %1$s<>();", new Object[]{ArrayList.class.getName(), BaseCell.class.getName()});
        for (UiCellsContainer.BaseCell cell : ctr.getCells()) {
            writer.beginBlock();
            if (cell instanceof UiCellsContainer.SimpleCell) {
                String alignment;
                String style;
                UiCellsContainer.SimpleCell simpleCell = (UiCellsContainer.SimpleCell)cell;
                CodeGenHelper.genLabelVar(simpleCell.getValue(), writer, "cellValue");
                switch (simpleCell.getStyle()) {
                    case BASIC: {
                        style = SimpleCell.Style.BASIC.name();
                        break;
                    }
                    case CAPTION: {
                        style = SimpleCell.Style.CAPTION.name();
                        break;
                    }
                    case VALUE: {
                        style = SimpleCell.Style.VALUE.name();
                        break;
                    }
                    case COMBINED: {
                        style = SimpleCell.Style.COMBINED.name();
                        break;
                    }
                    default: {
                        throw Xeption.forDeveloper((String)"unsupported cells container cell style {0}", (Object[])new Object[]{simpleCell.getStyle().name()});
                    }
                }
                switch (simpleCell.getAlignment()) {
                    case TOP_LEFT: {
                        alignment = Pos.TOP_LEFT.name();
                        break;
                    }
                    case TOP_CENTER: {
                        alignment = Pos.TOP_CENTER.name();
                        break;
                    }
                    case TOP_RIGHT: {
                        alignment = Pos.TOP_RIGHT.name();
                        break;
                    }
                    case CENTER_LEFT: {
                        alignment = Pos.CENTER_LEFT.name();
                        break;
                    }
                    case CENTER: {
                        alignment = Pos.CENTER.name();
                        break;
                    }
                    case CENTER_RIGHT: {
                        alignment = Pos.CENTER_RIGHT.name();
                        break;
                    }
                    case BOTTOM_LEFT: {
                        alignment = Pos.BOTTOM_LEFT.name();
                        break;
                    }
                    case BOTTOM_CENTER: {
                        alignment = Pos.BOTTOM_CENTER.name();
                        break;
                    }
                    case BOTTOM_RIGHT: {
                        alignment = Pos.BOTTOM_RIGHT.name();
                        break;
                    }
                    default: {
                        throw Xeption.forDeveloper((String)"unsupported cells container cell alignment {0}", (Object[])new Object[]{simpleCell.getAlignment().name()});
                    }
                }
                writer.code("%sCell = new %s(cellValue, %s, %s);", new Object[]{cell.getId(), SimpleCell.class.getName(), SimpleCell.class.getName() + ".Style." + style, Pos.class.getName() + '.' + alignment});
                CodeGenHelper.genSetHelp(simpleCell.getHelp(), writer, cell.getId() + "Cell");
            } else if (cell instanceof UiCellsContainer.ComplexCell) {
                UiElement payload = ((UiCellsContainer.ComplexCell)cell).getPayload();
                if (payload instanceof UiContainerReference) {
                    UiContainerReference ref = (UiContainerReference)payload;
                    writer.code("%s payloadNode = new %1$s(readonly);", new Object[]{ref.getId()});
                } else {
                    Widgets widget = Widgets.getFor((BaseUiWidget)payload);
                    writer.code("%s payloadNode;", new Object[]{widget.getWidgetClass(ctx, (BaseUiWidget)payload)});
                    widget.generateContainerFieldInitializer(writer, ctx, (BaseUiWidget)payload, "payload");
                }
                writer.code("%sCell = new %s<>(payloadNode);", new Object[]{cell.getId(), ComplexCell.class.getName()});
            } else {
                throw Xeption.forDeveloper((String)"unsupported type {0} of cell {1} in container {2}", (Object[])new Object[]{cell.getClass().getName(), cell.getId(), ctr.getId()});
            }
            if (cell.getColumnSpan() > 1) {
                writer.code("%sCell.setColSpan(%s);", new Object[]{cell.getId(), CellsContainerGenerator.getSpan(cell.getColumnSpan())});
            }
            if (cell.getRowSpan() > 1) {
                writer.code("%sCell.setRowSpan(%s);", new Object[]{cell.getId(), CellsContainerGenerator.getSpan(cell.getRowSpan())});
            }
            writer.code("cells.add(%sCell);", new Object[]{cell.getId()});
            writer.endBlock();
        }
        writer.code("getCells().addAll(cells);", new Object[0]);
        writer.endBlock();
        writer.endBlock();
    }

    private static String getSpan(int value) {
        return Integer.MAX_VALUE == value ? GridPane.class.getName() + ".REMAINING" : String.valueOf(value);
    }

    private static void generateFields(JavaWriter writer, GenerationContext ctx, UiCellsContainer ctr) throws Exception {
        for (UiCellsContainer.BaseCell cell : ctr.getCells()) {
            if (cell instanceof UiCellsContainer.SimpleCell) {
                writer.code("private final %s %sCell;", new Object[]{SimpleCell.class.getName(), cell.getId()});
                writer.blank();
                writer.beginBlock("public final %s get%sCell()", new Object[]{SimpleCell.class.getName(), GenUtil.capitalize((String)cell.getId())});
                writer.code("return %sCell;", new Object[]{cell.getId()});
                writer.endBlock();
            } else if (cell instanceof UiCellsContainer.ComplexCell) {
                UiElement payload = ((UiCellsContainer.ComplexCell)cell).getPayload();
                String payloadType = payload instanceof UiContainerReference ? ((UiContainerReference)payload).getId() : Widgets.getFor((BaseUiWidget)payload).getWidgetClass(ctx, (BaseUiWidget)payload);
                writer.code("private final %s<%s> %sCell;", new Object[]{ComplexCell.class.getName(), payloadType, cell.getId()});
                writer.blank();
                writer.beginBlock("public final %s<%s> get%sCell()", new Object[]{ComplexCell.class.getName(), payloadType, GenUtil.capitalize((String)cell.getId())});
                writer.code("return %sCell;", new Object[]{cell.getId()});
                writer.endBlock();
                writer.beginBlock("public final %s get%sNode()", new Object[]{payloadType, GenUtil.capitalize((String)cell.getId())});
                writer.code("return %sCell.getPayload();", new Object[]{cell.getId()});
                writer.endBlock();
                writer.blank();
            } else {
                throw Xeption.forDeveloper((String)"unsupported type {0} of cell {1} in container {2}", (Object[])new Object[]{cell.getClass().getName(), cell.getId(), ctr.getId()});
            }
            writer.blank();
        }
    }

    private static void generateMethods(JavaWriter writer, GenerationContext ctx, UiCellsContainer ctr) throws Exception {
    }

    private CellsContainerGenerator() {
    }
}

