/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.gen.Widgets;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.BaseCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.util.Executable;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.meta.ui.UiCellsContainer;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiGridContainer;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.meta.ui.UiSimpleContainer;
import com.gridnine.xtrip.common.meta.ui.UiTile;
import com.gridnine.xtrip.common.meta.ui.UiTilesSpace;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javafx.util.Pair;

final class ControllerGenerator {
    static void generate(JavaWriter writer, GenerationContext ctx, UiTilesSpace space) throws Exception {
        NestedElementGenerator overviewGen;
        ArrayList<NestedElementGenerator> generators = new ArrayList<NestedElementGenerator>();
        for (UiModel.Field prop : space.getProperties()) {
            generators.add(new PropertyGenerator(prop));
        }
        if (space.getOverview() != null) {
            overviewGen = NestedElementGenerator.forUiElement(ctx, "overview", space.getOverview());
            generators.add(overviewGen);
        } else {
            overviewGen = null;
        }
        LinkedHashMap<String, Pair> tile2gen = new LinkedHashMap<String, Pair>();
        for (UiTile tile : space.getTiles()) {
            NestedElementGenerator gen1 = null;
            if (tile.getFullPayload() != null) {
                gen1 = NestedElementGenerator.forUiElement(ctx, tile.getId() + "Full", tile.getFullPayload());
                generators.add(gen1);
            }
            NestedElementGenerator gen2 = null;
            if (tile.getCompactPayload() != null) {
                gen2 = NestedElementGenerator.forUiElement(ctx, tile.getId() + "Compact", tile.getCompactPayload());
                generators.add(gen2);
            }
            tile2gen.put(tile.getId(), new Pair(gen1, gen2));
        }
        ControllerGenerator.generate(writer, ctx, (BaseUiMetaElement)space, space.getModel(), generators, () -> {
            String spaceAcl;
            String string = spaceAcl = space.getAcl() == null ? null : space.getAcl().getId();
            if (overviewGen != null) {
                UiAclResource aclRes = null;
                if (space.getOverview() instanceof UiContainerReference) {
                    aclRes = ((BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiContainerReference)space.getOverview()).getId())).getAcl();
                }
                overviewGen.generateEnforceAcl(writer, ctx, aclRes == null ? spaceAcl : aclRes.getId());
            }
            writer.code("%s<%s<?, ?>> tilesList = new %s<>(%s);", new Object[]{List.class.getName(), Tile.class.getName(), ArrayList.class.getName(), String.valueOf(space.getTiles().size())});
            for (UiTile tile : space.getTiles()) {
                String acl = tile.getAcl() == null ? spaceAcl : tile.getAcl().getId();
                writer.beginBlock("if (!aclData.canView(%s))", new Object[]{acl == null ? "parentId" : '\"' + acl + '\"'});
                writer.code("tilesList.add(getView().get%sTile());", new Object[]{GenUtil.capitalize((String)tile.getId())});
                writer.endBlock();
                Pair pair = (Pair)tile2gen.get(tile.getId());
                if (pair.getKey() != null) {
                    ((NestedElementGenerator)pair.getKey()).generateEnforceAcl(writer, ctx, acl);
                }
                if (pair.getValue() != null) {
                    ((NestedElementGenerator)pair.getValue()).generateEnforceAcl(writer, ctx, acl);
                }
                writer.blank();
            }
            writer.code("getView().getForbiddenTiles().setAll(tilesList);", new Object[0]);
        });
    }

    static void generate(JavaWriter writer, GenerationContext ctx, UiGridContainer ctr) throws Exception {
        LinkedHashMap<String, NestedElementGenerator> generators = new LinkedHashMap<String, NestedElementGenerator>();
        for (UiModel.Field prop : ctr.getProperties()) {
            generators.put(prop.getId(), new PropertyGenerator(prop));
        }
        for (UiGridContainer.Cell cell : ctr.getCells()) {
            if (UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell)) continue;
            generators.put(cell.getId(), NestedElementGenerator.forUiElement(ctx, cell.getId(), cell.getPayload()));
        }
        ControllerGenerator.generate(writer, ctx, (BaseUiMetaElement)ctr, ctr.getModel(), generators.values(), () -> {
            writer.code("%s<%s<?>> cellsList = new %s<>(%s);", new Object[]{List.class.getName(), GridCell.class.getName(), ArrayList.class.getName(), String.valueOf(ctr.getCells().size())});
            String ctrAcl = ctr.getAcl() == null ? null : ctr.getAcl().getId();
            for (UiGridContainer.Cell cell : ctr.getCells()) {
                if (UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell)) continue;
                String acl = cell.getAcl() == null ? ctrAcl : cell.getAcl().getId();
                writer.beginBlock("if (!aclData.canView(%s))", new Object[]{acl == null ? "parentId" : '\"' + acl + '\"'});
                writer.code("cellsList.add(getView().get%sCell());", new Object[]{GenUtil.capitalize((String)cell.getId())});
                writer.endBlock();
                ((NestedElementGenerator)generators.get(cell.getId())).generateEnforceAcl(writer, ctx, acl);
            }
            writer.code("getView().getForbiddenCells().setAll(cellsList);", new Object[0]);
        });
    }

    static void generate(JavaWriter writer, GenerationContext ctx, UiCellsContainer ctr) throws Exception {
        LinkedHashMap<String, NestedElementGenerator> generators = new LinkedHashMap<String, NestedElementGenerator>();
        for (UiModel.Field prop : ctr.getProperties()) {
            generators.put(prop.getId(), new PropertyGenerator(prop));
        }
        for (UiCellsContainer.BaseCell cell : ctr.getCells()) {
            if (cell instanceof UiCellsContainer.SimpleCell) {
                generators.put(cell.getId(), new NestedElementGenerator(cell.getId()){

                    @Override
                    void generateReadData(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                        writer1.beginBlock("if (model != null && !%s.isBlank(model.get%s()))", new Object[]{TextUtil.class.getName(), GenUtil.capitalize((String)this.name)});
                        writer1.code("getView().get%sCell().setValue(model.get%1$s());", new Object[]{GenUtil.capitalize((String)this.name)});
                        writer1.endBlock();
                    }

                    @Override
                    void generateWriteData(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                    }

                    @Override
                    void generateSetReadonly(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                    }

                    @Override
                    void generateSetNotEditable(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                    }

                    @Override
                    void generateSetAclNotEditable(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                    }

                    @Override
                    void generateIsDataChanged(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                    }

                    @Override
                    void generateValidate(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                    }

                    @Override
                    void generateProperty(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                        writer1.beginBlock("public String get%s()", new Object[]{GenUtil.capitalize((String)this.name)});
                        writer1.code("return getView().get%sCell().getValue();", new Object[]{GenUtil.capitalize((String)this.name)});
                        writer1.endBlock();
                    }

                    @Override
                    void generateEnforceAcl(JavaWriter writer1, GenerationContext ctx1, String aclResourceId) throws Exception {
                    }

                    @Override
                    void generateIsDataAclEnforceable(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                    }

                    @Override
                    void generateEnforceDataAcl(JavaWriter writer1, GenerationContext ctx1) throws Exception {
                    }
                });
                continue;
            }
            if (cell instanceof UiCellsContainer.ComplexCell) {
                generators.put(cell.getId(), NestedElementGenerator.forUiElement(ctx, cell.getId(), ((UiCellsContainer.ComplexCell)cell).getPayload()));
                continue;
            }
            throw Xeption.forDeveloper((String)"unsupported type {0} of cell {1} in container {2}", (Object[])new Object[]{cell.getClass().getName(), cell.getId(), ctr.getId()});
        }
        ControllerGenerator.generate(writer, ctx, (BaseUiMetaElement)ctr, ctr.getModel(), generators.values(), () -> {
            writer.code("%s<%s> cellsList = new %s<>(%s);", new Object[]{List.class.getName(), BaseCell.class.getName(), ArrayList.class.getName(), String.valueOf(ctr.getCells().size())});
            String ctrAcl = ctr.getAcl() == null ? null : ctr.getAcl().getId();
            for (UiCellsContainer.BaseCell cell : ctr.getCells()) {
                String acl = cell.getAcl() == null ? ctrAcl : cell.getAcl().getId();
                writer.beginBlock("if (!aclData.canView(%s))", new Object[]{acl == null ? "parentId" : '\"' + acl + '\"'});
                writer.code("cellsList.add(getView().get%sCell());", new Object[]{GenUtil.capitalize((String)cell.getId())});
                writer.endBlock();
                ((NestedElementGenerator)generators.get(cell.getId())).generateEnforceAcl(writer, ctx, acl);
            }
            writer.code("getView().getForbiddenCells().setAll(cellsList);", new Object[0]);
        });
    }

    static void generate(JavaWriter writer, GenerationContext ctx, UiCardsContainer ctr) throws Exception {
        LinkedHashMap<String, NestedElementGenerator> generators = new LinkedHashMap<String, NestedElementGenerator>();
        for (UiModel.Field prop : ctr.getProperties()) {
            generators.put(prop.getId(), new PropertyGenerator(prop));
        }
        for (UiCardsContainer.Card card : ctr.getCards()) {
            generators.put(card.getId(), NestedElementGenerator.forUiElement(ctx, card.getId(), card.getPayload()));
        }
        ControllerGenerator.generate(writer, ctx, (BaseUiMetaElement)ctr, ctr.getModel(), generators.values(), () -> {
            writer.code("%s<%s<?>> cardsList = new %s<>(%s);", new Object[]{List.class.getName(), Card.class.getName(), ArrayList.class.getName(), String.valueOf(ctr.getCards().size())});
            String ctrAcl = ctr.getAcl() == null ? null : ctr.getAcl().getId();
            for (UiCardsContainer.Card card : ctr.getCards()) {
                String acl = card.getAcl() == null ? ctrAcl : card.getAcl().getId();
                writer.beginBlock("if (!aclData.canView(%s))", new Object[]{acl == null ? "parentId" : '\"' + acl + '\"'});
                writer.code("cardsList.add(getView().get%sCard());", new Object[]{GenUtil.capitalize((String)card.getId())});
                writer.endBlock();
                ((NestedElementGenerator)generators.get(card.getId())).generateEnforceAcl(writer, ctx, acl);
            }
            writer.code("getView().getForbiddenCards().setAll(cardsList);", new Object[0]);
        });
    }

    static void generate(JavaWriter writer, GenerationContext ctx, UiSimpleContainer ctr) throws Exception {
        NestedElementGenerator generator = NestedElementGenerator.forUiElement(ctx, "content", ctr.getPayload());
        ControllerGenerator.generate(writer, ctx, (BaseUiMetaElement)ctr, ctr.getModel(), Collections.singletonList(generator), () -> generator.generateEnforceAcl(writer, ctx, ctr.getAcl() == null ? null : ctr.getAcl().getId()));
    }

    private static void generate(JavaWriter writer, GenerationContext ctx, BaseUiMetaElement elm, UiModel model, Collection<NestedElementGenerator> generators, Executable enforceAclGenerator) throws Exception {
        writer.beginCompilationUnit(ctx.getOutFolder(), elm.getId() + "Controller");
        writer.doc("Controller class for {@link %s a view}.\r\nIt holds the reference to an instance of that view and  handles it's <b>state</b>.", new Object[]{GenUtil.getSimpleClassName((String)elm.getId())});
        if (elm.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        String controllerClassName = GenUtil.getSimpleClassName((String)elm.getId()) + "Controller";
        writer.beginBlock("public class %s implements %s<%s,%s>", new Object[]{controllerClassName, ViewController.class.getName(), elm.getId(), model.getClassName()});
        writer.beginBlock("public static %s forView(%s view)", new Object[]{controllerClassName, elm.getId()});
        writer.code("return (%s) view.getProperties().get(\"controller\");", new Object[]{controllerClassName});
        writer.endBlock();
        writer.beginBlock("public %s(boolean readonly)", new Object[]{controllerClassName, elm.getId()});
        writer.code("this(new %s(readonly), readonly);", new Object[]{elm.getId()});
        writer.endBlock();
        writer.beginBlock("public %s(%s view, boolean readonly)", new Object[]{controllerClassName, elm.getId()});
        writer.code("this.view = view;", new Object[0]);
        writer.code("this.view.getProperties().put(\"controller\", this);", new Object[0]);
        writer.code("this.readonly = readonly;", new Object[0]);
        writer.code("%s.onCreate(this);", new Object[]{ControllersRegistry.class.getName()});
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public final boolean isAwareOfControllersRegistry()", new Object[0]);
        writer.code("return true;", new Object[0]);
        writer.endBlock();
        writer.code("private final %s view;", new Object[]{elm.getId()});
        writer.blank();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public final %s getView()", new Object[]{elm.getId()});
        writer.code("return view;", new Object[0]);
        writer.endBlock();
        writer.code("private %s data;", new Object[]{model.getClassName()});
        writer.blank();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public final %s getData()", new Object[]{model.getClassName()});
        writer.code("return data;", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void readData(final %s model)", new Object[]{model.getClassName()});
        writer.code("data = model;", new Object[0]);
        writer.code("%s.beforeReadData(this, model);", new Object[]{ControllersRegistry.class.getName()});
        for (NestedElementGenerator generator : generators) {
            generator.generateReadData(writer, ctx);
        }
        writer.code("%s.afterReadData(this, model);", new Object[]{ControllersRegistry.class.getName()});
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void writeData(final %s model)", new Object[]{model.getClassName()});
        writer.code("%s.beforeWriteData(this, model);", new Object[]{ControllersRegistry.class.getName()});
        for (NestedElementGenerator generator : generators) {
            generator.generateWriteData(writer, ctx);
        }
        writer.code("%s.afterWriteData(this, model);", new Object[]{ControllersRegistry.class.getName()});
        writer.endBlock();
        writer.code("private boolean readonly;", new Object[0]);
        writer.blank();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public boolean isReadonly()", new Object[0]);
        writer.code("return readonly;", new Object[0]);
        writer.endBlock();
        writer.blank();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void setReadonly(final boolean readonly)", new Object[0]);
        writer.code("this.readonly = readonly;", new Object[0]);
        if (elm instanceof UiTilesSpace) {
            writer.code("getView().detuchHiddenNodes();", new Object[0]);
        }
        for (NestedElementGenerator generator : generators) {
            generator.generateSetReadonly(writer, ctx);
        }
        if (elm instanceof UiTilesSpace) {
            writer.code("getView().revalidateActions();", new Object[0]);
        }
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void setNotEditable(final boolean notEditable)", new Object[0]);
        for (NestedElementGenerator generator : generators) {
            generator.generateSetNotEditable(writer, ctx);
        }
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void setAclNotEditable(final boolean aclNotEditable)", new Object[0]);
        for (NestedElementGenerator generator : generators) {
            generator.generateSetAclNotEditable(writer, ctx);
        }
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public boolean isDataChanged()", new Object[0]);
        writer.beginBlock("if (readonly)", new Object[0]);
        writer.code("return false;", new Object[0]);
        writer.endBlock();
        for (NestedElementGenerator generator : generators) {
            generator.generateIsDataChanged(writer, ctx);
        }
        writer.code("return false;", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void validateData(%s<%s> messages)", new Object[]{List.class.getName(), Message.class.getName()});
        writer.code("%s.validateData(this, messages);", new Object[]{ControllersRegistry.class.getName()});
        for (NestedElementGenerator generator : generators) {
            generator.generateValidate(writer, ctx);
        }
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void enforceAcl(final %s aclData, final String parentId)", new Object[]{AppliedAclData.class.getName()});
        enforceAclGenerator.execute();
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public boolean isDataAclEnforceable()", new Object[0]);
        writer.beginBlock("if (%s.isDataAclEnforceable(this))", new Object[]{ControllersRegistry.class.getName()});
        writer.code("return true;", new Object[0]);
        writer.endBlock();
        for (NestedElementGenerator generator : generators) {
            generator.generateIsDataAclEnforceable(writer, ctx);
        }
        writer.code("return false;", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void enforceDataAcl(final %s<?, %s<?, ?>> rootController, final %s<String> deniedPermissions)", new Object[]{ViewController.class.getName(), DataTransferPackage.class.getName(), Set.class.getName()});
        writer.code("%s.enforceDataAcl(this, rootController, deniedPermissions);", new Object[]{ControllersRegistry.class.getName()});
        for (NestedElementGenerator generator : generators) {
            generator.generateEnforceDataAcl(writer, ctx);
        }
        writer.endBlock();
        for (NestedElementGenerator generator : generators) {
            generator.generateProperty(writer, ctx);
        }
        writer.endBlock();
        writer.endCompilationUnit();
    }

    static <E extends BaseMetaElement> E find(Iterable<E> coll, String id) {
        for (BaseMetaElement item : coll) {
            if (item == null || !id.equals(item.getId())) continue;
            return (E)item;
        }
        return null;
    }

    private ControllerGenerator() {
    }

    private static class PropertyGenerator
    extends NestedElementGenerator {
        private final UiModel.Field property;

        PropertyGenerator(UiModel.Field prop) {
            super(prop.getId());
            this.property = prop;
        }

        @Override
        void generateReadData(JavaWriter writer, GenerationContext ctx) throws Exception {
            if (!this.property.isCollection()) {
                String def;
                String getter = "get";
                switch (this.property.getType()) {
                    case "boolean": {
                        def = "false";
                        getter = "is";
                        break;
                    }
                    case "int": 
                    case "long": {
                        def = "0";
                        break;
                    }
                    case "double": 
                    case "float": {
                        def = "0.0";
                        break;
                    }
                    default: {
                        def = "null";
                    }
                }
                writer.code("getView().%sProperty().set(model == null ? %s : model.%s%s());", new Object[]{this.name, def, getter, GenUtil.capitalize((String)this.name)});
            } else {
                writer.code("getView().%sProperty().setAll(model == null ? %s.emptyList() : model.get%s());", new Object[]{this.name, Collections.class.getName(), GenUtil.capitalize((String)this.name)});
            }
        }

        @Override
        void generateWriteData(JavaWriter writer, GenerationContext ctx) throws Exception {
            if (!this.property.isCollection()) {
                writer.code("model.set%s(getView().%sProperty().get());", new Object[]{GenUtil.capitalize((String)this.name), this.name});
            } else {
                writer.code("model.get%s().clear();", new Object[]{GenUtil.capitalize((String)this.name)});
                writer.code("model.get%s().addAll(getView().%sProperty());", new Object[]{GenUtil.capitalize((String)this.name), this.name});
            }
        }

        @Override
        void generateSetReadonly(JavaWriter writer, GenerationContext ctx) throws Exception {
        }

        @Override
        void generateSetNotEditable(JavaWriter writer, GenerationContext ctx) throws Exception {
        }

        @Override
        void generateSetAclNotEditable(JavaWriter writer, GenerationContext ctx) throws Exception {
        }

        @Override
        void generateIsDataChanged(JavaWriter writer, GenerationContext ctx) throws Exception {
        }

        @Override
        void generateValidate(JavaWriter writer, GenerationContext ctx) throws Exception {
        }

        @Override
        void generateProperty(JavaWriter writer, GenerationContext ctx) throws Exception {
        }

        @Override
        void generateEnforceAcl(JavaWriter writer, GenerationContext ctx, String aclResourceId) throws Exception {
        }

        @Override
        void generateIsDataAclEnforceable(JavaWriter writer, GenerationContext ctx) throws Exception {
        }

        @Override
        void generateEnforceDataAcl(JavaWriter writer, GenerationContext ctx) throws Exception {
        }
    }

    private static class WidgetGenerator
    extends NestedElementGenerator {
        private final BaseUiWidget widget;

        WidgetGenerator(String n, BaseUiWidget wdg) {
            super(n);
            this.widget = wdg;
        }

        @Override
        void generateReadData(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerReadData(writer, ctx, this.widget, this.name);
        }

        @Override
        void generateWriteData(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerWriteData(writer, ctx, this.widget, this.name);
        }

        @Override
        void generateSetReadonly(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerReadonly(writer, ctx, this.widget, this.name);
        }

        @Override
        void generateSetNotEditable(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerNotEditable(writer, ctx, this.widget, this.name);
        }

        @Override
        void generateSetAclNotEditable(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerAclNotEditable(writer, ctx, this.widget, this.name);
        }

        @Override
        void generateIsDataChanged(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerIsDataChanged(writer, ctx, this.widget, this.name);
        }

        @Override
        void generateValidate(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerValidate(writer, ctx, this.widget, this.name);
        }

        @Override
        void generateProperty(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerProperty(writer, ctx, this.widget, this.name);
        }

        @Override
        void generateEnforceAcl(JavaWriter writer, GenerationContext ctx, String aclResourceId) throws Exception {
            Widgets.getFor(this.widget).generateControllerEnforceAcl(writer, ctx, this.widget, this.name, aclResourceId);
        }

        @Override
        void generateIsDataAclEnforceable(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerIsDataAclEnforceable(writer, ctx, this.widget, this.name);
        }

        @Override
        void generateEnforceDataAcl(JavaWriter writer, GenerationContext ctx) throws Exception {
            Widgets.getFor(this.widget).generateControllerEnforceDataAcl(writer, ctx, this.widget, this.name);
        }
    }

    private static class ContainerGenerator
    extends NestedElementGenerator {
        private final BaseUiContainer ctr;

        ContainerGenerator(String n, BaseUiContainer container) {
            super(n);
            this.ctr = container;
        }

        @Override
        void generateReadData(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.code("get%s().readData(model == null ? null : model.get%1$s());", new Object[]{GenUtil.capitalize((String)this.name)});
        }

        @Override
        void generateWriteData(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.code("get%s().writeData(model.get%1$s());", new Object[]{GenUtil.capitalize((String)this.name)});
        }

        @Override
        void generateSetReadonly(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.code("get%s().setReadonly(readonly);", new Object[]{GenUtil.capitalize((String)this.name)});
        }

        @Override
        void generateSetNotEditable(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.code("get%s().setNotEditable(notEditable);", new Object[]{GenUtil.capitalize((String)this.name)});
        }

        @Override
        void generateSetAclNotEditable(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.code("get%s().setAclNotEditable(aclNotEditable);", new Object[]{GenUtil.capitalize((String)this.name)});
        }

        @Override
        void generateIsDataChanged(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.beginBlock("if (get%s().isDataChanged())", new Object[]{GenUtil.capitalize((String)this.name)});
            writer.code("return true;", new Object[0]);
            writer.endBlock();
        }

        @Override
        void generateValidate(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.code("get%s().validateData(messages);", new Object[]{GenUtil.capitalize((String)this.name)});
        }

        @Override
        void generateProperty(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.code("private %s %s;", new Object[]{this.ctr.getId() + "Controller", this.name});
            writer.blank();
            writer.beginBlock("public %s get%s()", new Object[]{this.ctr.getId() + "Controller", GenUtil.capitalize((String)this.name)});
            writer.beginBlock("if (%s == null)", new Object[]{this.name});
            writer.code("%s = new %s(getView().get%sNode(), readonly);", new Object[]{this.name, this.ctr.getId() + "Controller", GenUtil.capitalize((String)this.name)});
            writer.endBlock();
            writer.code("return %s;", new Object[]{this.name});
            writer.endBlock();
        }

        @Override
        void generateEnforceAcl(JavaWriter writer, GenerationContext ctx, String aclResourceId) throws Exception {
            writer.code("get%s().enforceAcl(aclData, %s);", new Object[]{GenUtil.capitalize((String)this.name), aclResourceId == null ? "parentId" : '\"' + aclResourceId + '\"'});
        }

        @Override
        void generateIsDataAclEnforceable(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.beginBlock("if (get%s().isDataAclEnforceable())", new Object[]{GenUtil.capitalize((String)this.name)});
            writer.code("return true;", new Object[0]);
            writer.endBlock();
        }

        @Override
        void generateEnforceDataAcl(JavaWriter writer, GenerationContext ctx) throws Exception {
            writer.code("get%s().enforceDataAcl(rootController, deniedPermissions);", new Object[]{GenUtil.capitalize((String)this.name)});
        }
    }

    private static abstract class NestedElementGenerator {
        protected final String name;

        static NestedElementGenerator forUiElement(GenerationContext ctx, String name, UiElement element) {
            if (element instanceof UiContainerReference) {
                return new ContainerGenerator(name, (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiContainerReference)element).getId()));
            }
            return new WidgetGenerator(name, (BaseUiWidget)element);
        }

        NestedElementGenerator(String n) {
            this.name = n;
        }

        abstract void generateReadData(JavaWriter var1, GenerationContext var2) throws Exception;

        abstract void generateWriteData(JavaWriter var1, GenerationContext var2) throws Exception;

        abstract void generateSetReadonly(JavaWriter var1, GenerationContext var2) throws Exception;

        abstract void generateSetNotEditable(JavaWriter var1, GenerationContext var2) throws Exception;

        abstract void generateSetAclNotEditable(JavaWriter var1, GenerationContext var2) throws Exception;

        abstract void generateIsDataChanged(JavaWriter var1, GenerationContext var2) throws Exception;

        abstract void generateValidate(JavaWriter var1, GenerationContext var2) throws Exception;

        abstract void generateProperty(JavaWriter var1, GenerationContext var2) throws Exception;

        abstract void generateEnforceAcl(JavaWriter var1, GenerationContext var2, String var3) throws Exception;

        abstract void generateIsDataAclEnforceable(JavaWriter var1, GenerationContext var2) throws Exception;

        abstract void generateEnforceDataAcl(JavaWriter var1, GenerationContext var2) throws Exception;
    }
}

