/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.gen.CodeGenHelper;
import com.gridnine.xtrip.client.fx.core.gen.Widgets;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiGridContainer;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javafx.scene.layout.GridPane;

final class GridContainerGenerator {
    static void generate(JavaWriter writer, GenerationContext ctx, UiGridContainer ctr) throws Exception {
        writer.beginCompilationUnit(ctx.getOutFolder(), ctr.getId());
        writer.doc("Grid container generated from UI metadata:\n<dl><dt>view ID</dt><dd>%s</dd>\n<dt>model</dt><dd>{@link %s}</dd>\n<dt>controller</dt><dd>{@link %1$sController}</dd>\n<dt>sources</dt><dd>%s</dd></dl>", new Object[]{ctr.getId(), ctr.getModel().getClassName(), ctx.getUiMetaRegistry().getSources((BaseUiMetaElement)ctr).stream().map(url -> {
            String result = url.toExternalForm();
            int p = result.indexOf("plugins/");
            return p == -1 ? result : result.substring(p);
        }).collect(Collectors.joining("<br>"))});
        if (ctr.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public class %s extends %s", new Object[]{GenUtil.getSimpleClassName((String)ctr.getId()), GridContainer.class.getName()});
        GridContainerGenerator.generateConstructor(writer, ctx, ctr);
        CodeGenHelper.generateProperties(writer, ctr.getProperties());
        GridContainerGenerator.generateFields(writer, ctx, ctr);
        GridContainerGenerator.generateMethods(writer, ctx, ctr);
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private static void generateConstructor(JavaWriter writer, GenerationContext ctx, UiGridContainer ctr) throws Exception {
        writer.beginBlock("public %s(boolean readonly)", new Object[]{GenUtil.getSimpleClassName((String)ctr.getId())});
        writer.code("super(%s);", new Object[]{ctr.getColumns()});
        if (ctr.isAdaptive()) {
            writer.code("setAdaptive(true);", new Object[0]);
        }
        writer.code("%s<%s<?>> cells = new %1$s<>();", new Object[]{ArrayList.class.getName(), GridCell.class.getName()});
        for (UiGridContainer.Cell cell : ctr.getCells()) {
            if (UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell)) {
                writer.code("cells.add(%s.NEW_ROW_MARKER);", new Object[]{GridCell.class.getName()});
                continue;
            }
            writer.beginBlock();
            CodeGenHelper.genLabelVar(cell.getCaption(), writer, "cellCaption");
            UiElement payload = cell.getPayload();
            if (payload instanceof UiContainerReference) {
                UiContainerReference ref = (UiContainerReference)payload;
                writer.code("%s payloadNode = new %1$s(readonly);", new Object[]{ref.getId()});
            } else {
                Widgets widget = Widgets.getFor((BaseUiWidget)payload);
                writer.code("%s payloadNode;", new Object[]{widget.getWidgetClass(ctx, (BaseUiWidget)payload)});
                widget.generateContainerFieldInitializer(writer, ctx, (BaseUiWidget)payload, "payload");
            }
            writer.code("payloadNode.getProperties().put(%s.CELL_ID_PROPERTY_NAME, \"%s\");", new Object[]{GridCell.class.getName(), cell.getId()});
            writer.code("%sCell = new %s<>(cellCaption, payloadNode);", new Object[]{cell.getId(), GridCell.class.getName()});
            CodeGenHelper.genSetHelp(cell.getHelp(), writer, cell.getId() + "Cell");
            if (cell.getColumnSpan() > 1) {
                writer.code("%sCell.setColSpan(%s);", new Object[]{cell.getId(), GridContainerGenerator.getSpan(cell.getColumnSpan())});
            }
            if (cell.getRowSpan() > 1) {
                writer.code("%sCell.setRowSpan(%s);", new Object[]{cell.getId(), GridContainerGenerator.getSpan(cell.getRowSpan())});
            }
            if (cell.isHidden()) {
                writer.code("%sCell.setHidden(%s);", new Object[]{cell.getId(), String.valueOf(cell.isHidden())});
            }
            writer.code("cells.add(%sCell);", new Object[]{cell.getId()});
            writer.endBlock();
        }
        writer.code("getCells().addAll(cells);", new Object[0]);
        writer.endBlock();
    }

    private static String getSpan(int value) {
        return Integer.MAX_VALUE == value ? GridPane.class.getName() + ".REMAINING" : String.valueOf(value);
    }

    private static void generateFields(JavaWriter writer, GenerationContext ctx, UiGridContainer ctr) throws Exception {
        for (UiGridContainer.Cell cell : ctr.getCells()) {
            if (UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell)) continue;
            UiElement payload = cell.getPayload();
            String payloadType = payload instanceof UiContainerReference ? ((UiContainerReference)payload).getId() : Widgets.getFor((BaseUiWidget)payload).getWidgetClass(ctx, (BaseUiWidget)payload);
            writer.code("private final %s<%s> %sCell;", new Object[]{GridCell.class.getName(), payloadType, cell.getId()});
            writer.blank();
            writer.beginBlock("public final %s<%s> get%sCell()", new Object[]{GridCell.class.getName(), payloadType, GenUtil.capitalize((String)cell.getId())});
            writer.code("return %sCell;", new Object[]{cell.getId()});
            writer.endBlock();
            writer.beginBlock("public final %s get%sNode()", new Object[]{payloadType, GenUtil.capitalize((String)cell.getId())});
            writer.code("return %sCell.getPayload();", new Object[]{cell.getId()});
            writer.endBlock();
            writer.blank();
        }
    }

    private static void generateMethods(JavaWriter writer, GenerationContext ctx, UiGridContainer ctr) throws Exception {
    }

    private GridContainerGenerator() {
    }
}

