/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.gen.CodeGenHelper;
import com.gridnine.xtrip.client.fx.core.gen.Widgets;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiSimpleContainer;
import java.util.stream.Collectors;

final class SimpleContainerGenerator {
    static void generate(JavaWriter writer, GenerationContext ctx, UiSimpleContainer ctr) throws Exception {
        writer.beginCompilationUnit(ctx.getOutFolder(), ctr.getId());
        writer.doc("Simple container generated from UI metadata:\n<dl><dt>view ID</dt><dd>%s</dd>\n<dt>model</dt><dd>{@link %s}</dd>\n<dt>controller</dt><dd>{@link %1$sController}</dd>\n<dt>sources</dt><dd>%s</dd></dl>", new Object[]{ctr.getId(), ctr.getModel().getClassName(), ctx.getUiMetaRegistry().getSources((BaseUiMetaElement)ctr).stream().map(url -> {
            String result = url.toExternalForm();
            int p = result.indexOf("plugins/");
            return p == -1 ? result : result.substring(p);
        }).collect(Collectors.joining("<br>"))});
        if (ctr.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        String className = GenUtil.getSimpleClassName((String)ctr.getId());
        String contentType = ctr.getPayload() instanceof UiContainerReference ? ((UiContainerReference)ctr.getPayload()).getId() : Widgets.getFor((BaseUiWidget)ctr.getPayload()).getWidgetClass(ctx, (BaseUiWidget)ctr.getPayload());
        writer.beginBlock("public class %s extends %s<%s>", new Object[]{className, SimpleContainer.class.getName(), contentType});
        SimpleContainerGenerator.generateConstructor(writer, ctx, ctr);
        SimpleContainerGenerator.generateFields(writer, ctx, ctr);
        SimpleContainerGenerator.generateMethods(writer, ctx, ctr);
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private static void generateFields(JavaWriter writer, GenerationContext ctx, UiSimpleContainer ctr) throws Exception {
        String contentType;
        UiElement payload = ctr.getPayload();
        if (payload instanceof UiContainerReference) {
            UiContainerReference ref = (UiContainerReference)payload;
            contentType = ref.getId();
        } else {
            contentType = Widgets.getFor((BaseUiWidget)payload).getWidgetClass(ctx, (BaseUiWidget)payload);
        }
        writer.beginBlock("%s getContentNode()", new Object[]{contentType});
        writer.code("return getContent();", new Object[0]);
        writer.endBlock();
        writer.blank();
    }

    private static void generateMethods(JavaWriter writer, GenerationContext ctx, UiSimpleContainer ctr) throws Exception {
    }

    private static void generateConstructor(JavaWriter writer, GenerationContext ctx, UiSimpleContainer ctr) throws Exception {
        writer.beginBlock("public %s(boolean readonly)", new Object[]{GenUtil.getSimpleClassName((String)ctr.getId())});
        CodeGenHelper.genForLabel(ctr.getCaption(), writer, "this", "setCaption");
        UiElement payload = ctr.getPayload();
        if (payload instanceof UiContainerReference) {
            UiContainerReference ref = (UiContainerReference)payload;
            writer.code("%s contentNode = new %1$s(readonly);", new Object[]{ref.getId()});
        } else {
            Widgets widget = Widgets.getFor((BaseUiWidget)payload);
            writer.code("%s contentNode;", new Object[]{widget.getWidgetClass(ctx, (BaseUiWidget)payload)});
            widget.generateContainerFieldInitializer(writer, ctx, (BaseUiWidget)payload, "content");
        }
        writer.code("setContent(contentNode);", new Object[0]);
        writer.endBlock();
    }

    private SimpleContainerGenerator() {
    }
}

