/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextFieldSkin;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.Region;

class ClearableTextFieldSkin
extends CustomTextFieldSkin {
    private final SimpleBooleanProperty clearButtonVisible = new SimpleBooleanProperty();
    private Region clearButton;

    ClearableTextFieldSkin(final ClearableTextField textField) {
        super(textField);
        this.clearButtonVisible.bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{textField.hoverProperty(), textField.textProperty(), textField.editableProperty(), textField.focusedProperty()});
            }

            protected boolean computeValue() {
                return textField.isEditable() && !textField.isEmpty() && textField.isHover();
            }
        });
        this.clearButtonVisible.addListener((s, o, n) -> this.updateClearButton());
    }

    private void updateClearButton() {
        if (!this.clearButtonVisible.get() && this.clearButton != null) {
            this.getChildren().remove((Object)this.clearButton);
            this.clearButton = null;
            return;
        }
        if (this.clearButton != null) {
            return;
        }
        this.clearButton = Buttons.clearButton(() -> {
            ((ClearableTextField)this.getSkinnable()).requestFocus();
            ((ClearableTextField)this.getSkinnable()).clear();
        });
        this.getChildren().add((Object)this.clearButton);
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (this.clearButton == null) {
            return;
        }
        double fullHeight = h + this.snappedTopInset() + this.snappedBottomInset();
        double fullWidth = w + this.snappedLeftInset() + this.snappedRightInset();
        this.clearButton.relocate(fullWidth - this.clearButton.getWidth(), (fullHeight - this.clearButton.getHeight()) / 2.0);
    }
}

