/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class ControlsPane
extends HBox {
    public static final Predicate<ButtonType> NONE = type -> false;
    public static final Predicate<ButtonType> ADD_REMOVE = type -> type == ButtonType.ADD || type == ButtonType.REMOVE;
    public static final Predicate<ButtonType> ADD_REMOVE_REORDERING = type -> {
        switch (type) {
            case ADD: 
            case REMOVE: 
            case UP: 
            case DOWN: {
                return true;
            }
        }
        return false;
    };
    public static final Predicate<ButtonType> ADD_REMOVE_PREV_NEXT = type -> {
        switch (type) {
            case ADD: 
            case REMOVE: 
            case PREV: 
            case NEXT: {
                return true;
            }
        }
        return false;
    };
    public static final Predicate<ButtonType> REMOVE_PREV_NEXT = type -> {
        switch (type) {
            case REMOVE: 
            case PREV: 
            case NEXT: {
                return true;
            }
        }
        return false;
    };
    public static final Predicate<ButtonType> ADD_REMOVE_PREV_NEXT_REORDERING = type -> {
        switch (type) {
            case ADD: 
            case REMOVE: 
            case UP: 
            case DOWN: 
            case PREV: 
            case NEXT: {
                return true;
            }
        }
        return false;
    };

    public static Region createButton(ButtonType type, EventHandler<? super MouseEvent> handler) {
        return ControlsPane.createButton(type, handler, null);
    }

    public static Region createButton(final ButtonType type, EventHandler<? super MouseEvent> handler, ObservableValue<? extends Boolean> disabledBinding) {
        StackPane result = new StackPane();
        IconShape iconShape = new IconShape(){

            @Override
            public String getParentStyle() {
                return String.format("%s-parent", this.getStyle());
            }

            @Override
            public String getStyle() {
                return String.format("icon-shape-controls-%s", type.getStyleClass());
            }
        };
        IconNode iconNode = new IconNode(iconShape, (Styleable)result, type == ButtonType.ADD || type == ButtonType.REMOVE || type == ButtonType.DOWNLOAD || type == ButtonType.UPLOAD ? StandardIconIntentions.CONTROLS_QTY : StandardIconIntentions.CONTROLS_POS, (Styleable)result);
        result.getChildren().add((Object)iconNode);
        result.getStyleClass().add((Object)"control-button");
        result.setOnMouseReleased(handler);
        if (disabledBinding != null) {
            result.disableProperty().bind(disabledBinding);
        }
        return result;
    }

    public ControlsPane() {
        this.getStyleClass().add((Object)"xtrip-controls-pane");
    }

    public Region addButton(ButtonType type, EventHandler<? super MouseEvent> handler) {
        return this.addButton(type, handler, null);
    }

    public Region addButton(ButtonType type, EventHandler<? super MouseEvent> handler, ObservableValue<? extends Boolean> disabledBinding) {
        Region result = ControlsPane.createButton(type, handler, disabledBinding);
        this.getChildren().add((Object)result);
        return result;
    }

    public static enum ButtonType {
        ADD{

            @Override
            String getStyleClass() {
                return "add";
            }
        }
        ,
        REMOVE{

            @Override
            String getStyleClass() {
                return "remove";
            }
        }
        ,
        UP{

            @Override
            String getStyleClass() {
                return "up";
            }
        }
        ,
        DOWN{

            @Override
            String getStyleClass() {
                return "down";
            }
        }
        ,
        PREV{

            @Override
            String getStyleClass() {
                return "prev";
            }
        }
        ,
        NEXT{

            @Override
            String getStyleClass() {
                return "next";
            }
        }
        ,
        EDIT{

            @Override
            String getStyleClass() {
                return "edit";
            }
        }
        ,
        EDIT_CODE{

            @Override
            String getStyleClass() {
                return "code";
            }
        }
        ,
        DOWNLOAD{

            @Override
            String getStyleClass() {
                return "download";
            }
        }
        ,
        UPLOAD{

            @Override
            String getStyleClass() {
                return "upload";
            }
        };


        abstract String getStyleClass();
    }
}

