/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextFieldSkin;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.Clipboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTextField
extends TextField {
    private final ObjectProperty<Node> left = new SimpleObjectProperty((Object)this, "left");
    private final ObjectProperty<Node> right = new SimpleObjectProperty((Object)this, "right");

    public static boolean sameNormalizedText(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        String normalized1 = str1.trim().replaceAll("[\\n\\r]", "").replaceAll("\\s+", " ");
        String normalized2 = str2.trim().replaceAll("[\\n\\r]", "").replaceAll("\\s+", " ");
        return normalized1.equals(normalized2);
    }

    static void handlePaste(TextInputControl ctrl) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (!clipboard.hasString()) {
            return;
        }
        String text = clipboard.getString();
        if (text == null) {
            return;
        }
        if (!text.isEmpty()) {
            Logger log = LoggerFactory.getLogger(CustomTextField.class);
            if (log.isDebugEnabled()) {
                log.debug("PASTE data " + Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8)));
            }
            StringBuffer buf = new StringBuffer(text.length());
            for (char ch : text.toCharArray()) {
                if (ch == '\u0000') break;
                if (ch >= '\ufff0' && ch <= '\uffff') continue;
                buf.append(ch);
            }
            text = buf.toString();
        }
        ctrl.replaceSelection(text);
    }

    public CustomTextField() {
        this.getStyleClass().add((Object)"custom-text-field");
        this.setPromptText(UiUtil.NULL_TEXT);
    }

    public void paste() {
        CustomTextField.handlePaste((TextInputControl)this);
    }

    public final ObjectProperty<Node> leftProperty() {
        return this.left;
    }

    public final Node getLeft() {
        return (Node)this.left.get();
    }

    public final void setLeft(Node value) {
        this.left.set((Object)value);
    }

    public final ObjectProperty<Node> rightProperty() {
        return this.right;
    }

    public final Node getRight() {
        return (Node)this.right.get();
    }

    public final void setRight(Node value) {
        this.right.set((Object)value);
    }

    protected Skin<?> createDefaultSkin() {
        return new CustomTextFieldSkin(this);
    }
}

