/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.lib.components.text.RichTextFlow;
import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.net.URL;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.PopupControl;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import javafx.stage.PopupWindow;

public class QuickHelp {
    private final String content;
    private final URL resource;
    private final Parent node;

    public static void show(QuickHelp help, Region anchor) {
        PopupControl popup;
        if (help.content != null) {
            RichTextFlow rtf = new RichTextFlow(TextHandler.SIMPLE_HTML, help.content);
            ScrollPane scrollPane = new ScrollPane((Node)rtf);
            scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            scrollPane.getStyleClass().addAll((Object[])new String[]{"xtrip-scroll-alt", "quick-help"});
            scrollPane.setFitToWidth(true);
            popup = UiUtil.createPopup((Parent)scrollPane);
        } else if (help.resource != null) {
            WebView view = new WebView();
            view.setContextMenuEnabled(false);
            StackPane pane = new StackPane(new Node[]{view});
            pane.getStyleClass().addAll((Object[])new String[]{"quick-help", "large"});
            popup = UiUtil.createPopup((Parent)pane);
            view.getEngine().load(help.resource.toExternalForm());
        } else {
            ScrollPane scrollPane = new ScrollPane((Node)help.node);
            scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            scrollPane.getStyleClass().addAll((Object[])new String[]{"quick-help", "large"});
            scrollPane.setFitToWidth(true);
            popup = UiUtil.createPopup((Parent)scrollPane);
        }
        popup.addEventFilter(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode() == KeyCode.ESCAPE) {
                popup.hide();
            }
        });
        UiUtil.showPopup((PopupWindow)popup, anchor);
    }

    public QuickHelp(String htmlContent) {
        this.content = htmlContent;
        this.resource = null;
        this.node = null;
    }

    public QuickHelp(URL htmlResource) {
        this.content = null;
        this.resource = htmlResource;
        this.node = null;
    }

    public QuickHelp(Parent node) {
        this.content = null;
        this.resource = null;
        this.node = node;
    }

    public String getContent() {
        return this.content;
    }
}

