/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.icon;

import com.gridnine.xtrip.client.fx.core.res.FxRes;
import com.gridnine.xtrip.common.util.DebugUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public final class IconCache {
    public static final DoubleProperty SCALE = new SimpleDoubleProperty(1.0);
    private static final Map<String, Image> IMAGES = new HashMap<String, Image>();
    private static final IconCache INSTANCE = new IconCache();
    private final SnapshotParameters parameters = new SnapshotParameters();

    private IconCache() {
        this.parameters.setFill((Paint)Color.TRANSPARENT);
        SCALE.addListener((observable, oldValue, newValue) -> IMAGES.clear());
    }

    public static IconCache get() {
        return INSTANCE;
    }

    public String dump() {
        StringBuilder dump = new StringBuilder();
        dump.append("size -> " + IMAGES.size());
        dump.append("\n");
        dump.append(DebugUtil.decorate((Iterable)IMAGES.entrySet().stream().collect(Collectors.toList()).stream().sorted((o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey())).map(entry -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("key -> " + (String)entry.getKey());
            stringBuilder.append("\n");
            stringBuilder.append("value -> " + String.format("%sx%s", String.valueOf(((Image)entry.getValue()).getWidth()), String.valueOf(((Image)entry.getValue()).getHeight())));
            return stringBuilder.toString();
        }).collect(Collectors.toList()), null, (String)"entries", (boolean)true));
        return dump.toString();
    }

    public Image getImage(String shapeStyle, String intentionStyle) {
        if (shapeStyle == null || intentionStyle == null) {
            return null;
        }
        String key = String.format("%s_%s", shapeStyle, intentionStyle);
        Image image = IMAGES.get(key);
        if (image == null) {
            image = this.createImage(shapeStyle, intentionStyle);
            IMAGES.put(key, image);
        }
        return image;
    }

    private Image createImage(String shapeStyle, String intentionStyle) {
        StackPane innerPane = new StackPane();
        innerPane.getStyleClass().add((Object)"image-cache-inner-pane");
        innerPane.setId("debug-icon-cache-inner-pane");
        innerPane.setScaleShape(false);
        innerPane.setCenterShape(false);
        StackPane outerPane = new StackPane();
        outerPane.getStyleClass().add((Object)"image-cache-outer-pane");
        outerPane.setId("debug-icon-cache-outer-pane");
        outerPane.setScaleX(SCALE.get());
        outerPane.setScaleY(SCALE.get());
        outerPane.getChildren().add((Object)innerPane);
        innerPane.getStyleClass().setAll((Object[])new String[]{shapeStyle, intentionStyle});
        Scene scene = new Scene((Parent)outerPane);
        FxRes.addStylesheets(scene);
        return outerPane.snapshot(this.parameters, null);
    }
}

