/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.menu;

import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.Region;

public class CustomContextMenu
extends ContextMenu {
    private static final String MENU_ITEM_FIRST_STYLE = "menu-item-first";
    private static final String MENU_ITEM_LAST_STYLE = "menu-item-last";
    private MenuItem firstItem = null;
    private MenuItem lastItem = null;

    public CustomContextMenu() {
        this.getStyleClass().add((Object)"xtrip-context-menu");
        this.createListeners();
    }

    public CustomContextMenu(MenuItem ... items) {
        super(items);
        this.getStyleClass().add((Object)"xtrip-context-menu");
        this.createListeners();
    }

    private void createListeners() {
        this.getItems().addListener(change -> {
            if (this.firstItem != null) {
                this.firstItem.getStyleClass().remove((Object)MENU_ITEM_FIRST_STYLE);
            }
            if (this.lastItem != null) {
                this.lastItem.getStyleClass().remove((Object)MENU_ITEM_LAST_STYLE);
            }
            MenuItem menuItem = this.firstItem = this.getItems().size() > 0 ? (MenuItem)this.getItems().get(0) : null;
            if (this.firstItem != null) {
                this.firstItem.getStyleClass().add((Object)MENU_ITEM_FIRST_STYLE);
            }
            MenuItem menuItem2 = this.lastItem = this.getItems().size() > 0 ? (MenuItem)this.getItems().get(this.getItems().size() - 1) : null;
            if (this.lastItem != null) {
                this.lastItem.getStyleClass().add((Object)MENU_ITEM_LAST_STYLE);
            }
            this.update();
        });
    }

    protected void show() {
        double anchorX = this.getAnchorX();
        double anchorY = this.getAnchorY();
        this.setAnchorX(Double.MIN_VALUE);
        this.setAnchorY(Double.MIN_VALUE);
        super.show();
        super.hide();
        double menuWidth = this.getPrefWidth();
        double itemWidth = this.getItems().stream().filter(item -> item instanceof CustomMenuItem).mapToDouble(item -> ((CustomMenuItem)((Object)item)).getContent().prefWidth(-1.0)).max().orElse(0.0);
        double width = Math.max(menuWidth, itemWidth);
        this.getItems().stream().filter(item -> item instanceof CustomMenuItem).forEach(item -> ((Region)((CustomMenuItem)((Object)item)).getContent()).setPrefWidth(width));
        super.show();
        super.hide();
        this.setAnchorX(anchorX);
        this.setAnchorY(anchorY);
        double updateWidth = Math.max(itemWidth, width - (this.getWidth() - width));
        this.getItems().stream().filter(item -> item instanceof CustomMenuItem).forEach(item -> ((Region)((CustomMenuItem)((Object)item)).getContent()).setPrefWidth(updateWidth));
        this.update();
        super.show();
    }

    public void update() {
        this.getItems().stream().filter(item -> item instanceof CustomMenuItem).forEach(item -> ((CustomMenuItem)((Object)item)).update());
    }
}

