/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.menu;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomCheckMenuItem;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class CustomMenuItem
extends javafx.scene.control.CustomMenuItem {
    private static final String DEFAULT_STYLE_CLASS = "xtrip-custom-menu-item";
    private ObjectProperty<IconShape> shape;
    private StringProperty title;
    private final ObservableList<MenuItemButton> buttons = FXCollections.observableArrayList();

    public CustomMenuItem() {
        this(null, null);
    }

    public CustomMenuItem(String title) {
        this(null, title);
    }

    public CustomMenuItem(IconShape shape, String title) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        CustomMenuItemPane pane = new CustomMenuItemPane(this);
        pane.getStyleClass().add((Object)"container-pane");
        this.setContent((Node)pane);
        this.setShape(shape);
        this.setTitle(title);
    }

    public final void setShape(IconShape value) {
        this.shapeProperty().set((Object)value);
    }

    public final IconShape getShape() {
        return this.shape != null ? (IconShape)this.shape.get() : null;
    }

    public final ObjectProperty<IconShape> shapeProperty() {
        if (this.shape == null) {
            this.shape = new SimpleObjectProperty((Object)this, "shape");
        }
        return this.shape;
    }

    public final void setTitle(String value) {
        this.titleProperty().set((Object)value);
    }

    public final String getTitle() {
        return this.title != null ? (String)this.title.get() : null;
    }

    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty((Object)this, "title");
        }
        return this.title;
    }

    public final ObservableList<MenuItemButton> getButtons() {
        return this.buttons;
    }

    protected void update() {
        ((CustomMenuItemPane)this.getContent()).update();
    }

    private static class CustomMenuItemPane
    extends StackPane {
        private final CustomMenuItem menuItem;
        private IconNode controlIcon;
        private Node controlGap;
        private IconNode imageIcon;
        private Node imageGap;
        private Label titleLabel;
        private Node buttonsGap;
        private GridPane buttonsPane;
        private final Map<MenuItemButton, IconNode> buttonIcons = new HashMap<MenuItemButton, IconNode>();

        public CustomMenuItemPane(CustomMenuItem menuItem) {
            this.menuItem = menuItem;
            this.createGUI();
            this.createListeners();
        }

        public void createGUI() {
            this.getStyleClass().addAll((Object[])new String[]{"xtrip-custom-menu-item-pane"});
            Pane menuItemPane = this.createMenuItemPane();
            this.getChildren().setAll((Object[])new Node[]{menuItemPane});
        }

        private Pane createMenuItemPane() {
            GridPane pane = new GridPane();
            this.controlIcon = new IconNode(StandardIconShapes.UNDEFINED, (Styleable)this.menuItem, StandardIconIntentions.MENU_ITEM_CONTROL, (Styleable)this.menuItem);
            this.controlIcon.getStyleClass().setAll((Object[])new String[]{"control-icon"});
            UiUtil.setHidden((Node)this.controlIcon, true);
            this.controlGap = new Region();
            this.controlGap.getStyleClass().setAll((Object[])new String[]{"control-gap"});
            UiUtil.setHidden(this.controlGap, true);
            this.imageIcon = new IconNode(StandardIconShapes.UNDEFINED, (Styleable)this.menuItem, StandardIconIntentions.MENU_ITEM_DECORATION, (Styleable)this.menuItem);
            this.imageIcon.getStyleClass().setAll((Object[])new String[]{"image-icon"});
            UiUtil.setHidden((Node)this.imageIcon, true);
            this.imageGap = new Region();
            this.imageGap.getStyleClass().setAll((Object[])new String[]{"image-gap"});
            UiUtil.setHidden(this.imageGap, true);
            this.titleLabel = new Label();
            this.titleLabel.getStyleClass().setAll((Object[])new String[]{"title-label"});
            UiUtil.setHidden((Node)this.titleLabel, true);
            this.buttonsGap = new Region();
            this.buttonsGap.getStyleClass().setAll((Object[])new String[]{"buttons-gap"});
            UiUtil.setHidden(this.buttonsGap, true);
            this.buttonsPane = new GridPane();
            this.buttonsPane.getStyleClass().setAll((Object[])new String[]{"buttons-pane"});
            UiUtil.setHidden((Node)this.buttonsPane, true);
            UiUtil.gridPosition(pane, (Node)this.controlIcon).col(0).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition(pane, this.controlGap).col(1).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition(pane, (Node)this.imageIcon).col(2).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition(pane, this.imageGap).col(3).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition(pane, (Node)this.titleLabel).col(4).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition(pane, this.buttonsGap).col(5).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition(pane, (Node)this.buttonsPane).col(6).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            return pane;
        }

        public void createListeners() {
            if (this.menuItem instanceof CustomCheckMenuItem) {
                final CustomCheckMenuItem checkMenuItem = (CustomCheckMenuItem)this.menuItem;
                checkMenuItem.checkShapeProperty().addListener((observable, oldValue, newValue) -> {
                    this.controlIcon.setIconShape((IconShape)newValue);
                    UiUtil.setHidden((Node)this.controlIcon, newValue == null);
                    UiUtil.setHidden(this.controlGap, newValue == null);
                });
                this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        checkMenuItem.setChecked(!checkMenuItem.isChecked());
                    }
                });
            }
            this.menuItem.shapeProperty().addListener((observable, oldValue, newValue) -> {
                this.imageIcon.setIconShape((IconShape)newValue);
                UiUtil.setHidden((Node)this.imageIcon, newValue == null);
                UiUtil.setHidden(this.imageGap, newValue == null);
            });
            this.menuItem.titleProperty().addListener((observable, oldValue, newValue) -> {
                this.titleLabel.setText(newValue);
                UiUtil.setHidden((Node)this.titleLabel, newValue == null);
            });
            this.menuItem.getButtons().addListener(change -> {
                this.buttonIcons.clear();
                this.buttonsPane.getChildren().clear();
                int count = 0;
                for (MenuItemButton button : this.menuItem.getButtons()) {
                    IconNode buttonIcon = new IconNode(button.getShape(), (Styleable)this.menuItem, button.getIntention(), (Styleable)this.menuItem);
                    buttonIcon.getStyleClass().setAll((Object[])new String[]{"button-icon"});
                    if (!button.isPersistent()) {
                        buttonIcon.setVisible(this.isHover());
                        this.hoverProperty().addListener((observable, oldValue, newValue) -> buttonIcon.setVisible(this.isHover()));
                    }
                    buttonIcon.setOnMousePressed(event -> {
                        button.handle();
                        event.consume();
                    });
                    this.buttonIcons.put(button, buttonIcon);
                    UiUtil.gridPosition(this.buttonsPane, (Node)buttonIcon).col(count).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.NEVER).vGrow(Priority.ALWAYS).place();
                    ++count;
                }
                UiUtil.setHidden(this.buttonsGap, this.menuItem.getButtons().size() == 0);
                UiUtil.setHidden((Node)this.buttonsPane, this.menuItem.getButtons().size() == 0);
            });
        }

        protected void update() {
            this.buttonIcons.entrySet().stream().forEach(entry -> ((IconNode)((Object)((Object)entry.getValue()))).setDisable(!((MenuItemButton)entry.getKey()).isEnabled()));
        }
    }

    public static interface MenuItemButton {
        public IconShape getShape();

        public IconIntention getIntention();

        public boolean isPersistent();

        public boolean isEnabled();

        public void handle();
    }
}

