/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.progressindicator;

import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.TerminationType;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import java.util.ArrayList;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class CustomProgressIndicator
extends StackPane {
    public static final double INDETERMINATE_PROGRESS = -1.0;
    private static final Image[] INDETERMINATE_FRAMES = CustomProgressIndicator.loadFrames("indeterminate", 1, 24);
    private static final Image[] INDETERMINATE_TO_PROGRESS_FRAMES = CustomProgressIndicator.loadFrames("indeterminate2progress", 1, 25);
    private static final Image[] PROGRESS_FRAMES = CustomProgressIndicator.loadFrames("progress", 0, 25);
    private static final Image[] PROGRESS_TO_SUCCESS_FRAMES = CustomProgressIndicator.loadFrames("progress2success", 1, 13);
    private static final Image[] PROGRESS_TO_ABORT_FRAMES = CustomProgressIndicator.loadFrames("progress2abort", 1, 10);
    private static final Image[] PROGRESS_TO_FAIL_FRAMES = CustomProgressIndicator.loadFrames("progress2fail", 1, 13);
    private final SimpleDoubleProperty progress = new SimpleDoubleProperty(-1.0);
    private final SimpleObjectProperty<TerminationType> terminationType = new SimpleObjectProperty();
    final ImageView imageView = new ImageView();
    private Animation animation;

    private static Image[] loadFrames(String name, int startIdx, int count) {
        Image[] result = new Image[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new Image(CustomProgressIndicator.class.getResource(String.format("%s/%02d.png", name, startIdx + i)).toString());
        }
        return result;
    }

    static int frac2index(double frac, int total) {
        return (int)Math.round(frac * (double)(total - 1));
    }

    public CustomProgressIndicator() {
        this.getStyleClass().add((Object)"custom-progress-indicator");
        this.getChildren().add((Object)this.imageView);
        this.progress.addListener((s, o, n) -> this.transit(o.doubleValue(), n.doubleValue()));
        this.terminationType.addListener((s, o, n) -> this.handleTerminationType((TerminationType)((Object)n)));
        this.sceneProperty().addListener((s, o, n) -> {
            if (n == null) {
                if (this.animation != null) {
                    this.animation.stop();
                    this.animation = null;
                }
            } else if (this.terminationType.get() == null) {
                this.transit(this.progress.get(), this.progress.get());
            } else {
                this.handleTerminationType((TerminationType)((Object)((Object)this.terminationType.get())));
            }
        });
        FxUtil.submitToFxThread(() -> this.transit(-1.0, this.progress.get()));
    }

    private void handleTerminationType(TerminationType tt) {
        Image[] frames;
        if (this.getScene() == null) {
            return;
        }
        if (this.animation != null && this.animation.getStatus() == Animation.Status.RUNNING) {
            this.animation.stop();
            FxUtil.submitToFxThread(() -> this.handleTerminationType(tt));
            return;
        }
        if (tt == null) {
            FxUtil.submitToFxThread(() -> this.transit(-1.0, this.progress.get()));
            return;
        }
        switch (tt) {
            case ABORT: {
                frames = PROGRESS_TO_ABORT_FRAMES;
                break;
            }
            case FAIL: {
                frames = PROGRESS_TO_FAIL_FRAMES;
                break;
            }
            case SUCCESS: {
                frames = PROGRESS_TO_SUCCESS_FRAMES;
                break;
            }
            default: {
                frames = PROGRESS_TO_SUCCESS_FRAMES;
            }
        }
        this.animation = this.createAnimation(frames, 0, frames.length - 1);
        this.animation.play();
    }

    private void transit(double fromValue, double toValue) {
        if (this.getScene() == null) {
            return;
        }
        if (this.terminationType.get() != null) {
            return;
        }
        if (this.animation != null && this.animation.getStatus() == Animation.Status.RUNNING) {
            this.animation.stop();
            FxUtil.submitToFxThread(() -> this.transit(fromValue, toValue));
            return;
        }
        if (toValue < 0.0) {
            this.animation = this.createAnimation(INDETERMINATE_FRAMES, 0, INDETERMINATE_FRAMES.length - 1);
            this.animation.setCycleCount(-1);
            this.animation.play();
            return;
        }
        if (fromValue >= 0.0 && toValue >= 0.0) {
            this.animation = this.createAnimation(PROGRESS_FRAMES, CustomProgressIndicator.frac2index(fromValue > 1.0 ? 1.0 : fromValue, PROGRESS_FRAMES.length), CustomProgressIndicator.frac2index(toValue > 1.0 ? 1.0 : toValue, PROGRESS_FRAMES.length));
            this.animation.play();
            return;
        }
        int left = 0;
        int progressIdx = CustomProgressIndicator.frac2index(toValue > 1.0 ? 1.0 : toValue, PROGRESS_FRAMES.length);
        for (int i = 0; i < INDETERMINATE_FRAMES.length; ++i) {
            if (this.imageView.getImage() != INDETERMINATE_FRAMES[i]) continue;
            left = INDETERMINATE_FRAMES.length - i - 1;
            break;
        }
        Image[] frames = new Image[left + INDETERMINATE_TO_PROGRESS_FRAMES.length + progressIdx + 1];
        if (left > 0) {
            System.arraycopy(INDETERMINATE_FRAMES, INDETERMINATE_FRAMES.length - left, frames, 0, left);
        }
        System.arraycopy(INDETERMINATE_TO_PROGRESS_FRAMES, 0, frames, left, INDETERMINATE_TO_PROGRESS_FRAMES.length);
        System.arraycopy(PROGRESS_FRAMES, 0, frames, left + INDETERMINATE_TO_PROGRESS_FRAMES.length, progressIdx + 1);
        this.animation = this.createAnimation(frames, 0, frames.length - 1);
        this.animation.play();
    }

    private Animation createAnimation(Image[] frames, int firstIdx, int lastIdx) {
        ArrayList<KeyFrame> keyFrames;
        int framesCount;
        if (lastIdx >= firstIdx) {
            framesCount = lastIdx - firstIdx + 1;
            keyFrames = new ArrayList<KeyFrame>(framesCount);
            for (int i = 0; i < framesCount; ++i) {
                keyFrames.add(new KeyFrame(Duration.millis((double)(i * 70)), new KeyValue[]{new KeyValue((WritableValue)this.imageView.imageProperty(), (Object)frames[firstIdx + i], Interpolator.DISCRETE)}));
            }
        } else {
            framesCount = firstIdx - lastIdx + 1;
            keyFrames = new ArrayList(framesCount);
            for (int i = 0; i < framesCount; ++i) {
                keyFrames.add(new KeyFrame(Duration.millis((double)(i * 70)), new KeyValue[]{new KeyValue((WritableValue)this.imageView.imageProperty(), (Object)frames[firstIdx - i], Interpolator.DISCRETE)}));
            }
        }
        Timeline result = new Timeline();
        result.getKeyFrames().addAll(keyFrames);
        return result;
    }

    public DoubleProperty progressProperty() {
        return this.progress;
    }

    public double getProgress() {
        return this.progress.get();
    }

    public void setProgress(double value) {
        this.progress.set(value);
    }

    public void setTerminationType(TerminationType value) {
        this.terminationType.set((Object)value);
    }
}

