/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.suggestions;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsPopup;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

abstract class BaseKeyHandler<T>
implements EventHandler<KeyEvent> {
    protected final TextField editor;
    private boolean moveCaretToPos = false;
    private int caretPos;
    protected SuggestionsPopup<T> popup;

    protected BaseKeyHandler(TextField edtr) {
        this.editor = edtr;
    }

    void dispose() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    public void handle(KeyEvent event) {
        KeyCode keyCode = event.getCode();
        if (keyCode == KeyCode.UP) {
            this.caretPos = -1;
            this.moveCaret(this.editor.getText().length());
            return;
        }
        if (keyCode == KeyCode.DOWN) {
            if (this.popup == null || !this.popup.isShowing()) {
                this.initiateSession();
            }
            this.caretPos = -1;
            this.moveCaret(this.editor.getText().length());
            return;
        }
        if (keyCode == KeyCode.BACK_SPACE) {
            this.moveCaretToPos = true;
            this.caretPos = this.editor.getCaretPosition();
        } else if (keyCode == KeyCode.DELETE) {
            this.moveCaretToPos = true;
            this.caretPos = this.editor.getCaretPosition();
        } else if (keyCode == KeyCode.ENTER || keyCode == KeyCode.ESCAPE || keyCode == KeyCode.RIGHT || keyCode == KeyCode.LEFT || keyCode.equals((Object)KeyCode.SHIFT) || event.isShiftDown() || keyCode.equals((Object)KeyCode.ALT) || event.isAltDown() || keyCode.equals((Object)KeyCode.CONTROL) || event.isControlDown() || keyCode == KeyCode.HOME || keyCode == KeyCode.END || keyCode == KeyCode.TAB) {
            return;
        }
        if (!this.moveCaretToPos) {
            this.caretPos = -1;
        }
        this.moveCaret(this.editor.getText().length());
        this.initiateSession();
    }

    private void moveCaret(int textLength) {
        if (this.caretPos == -1) {
            this.editor.positionCaret(textLength);
        } else {
            this.editor.positionCaret(this.caretPos);
        }
        this.moveCaretToPos = false;
    }

    protected abstract void initiateSession();
}

