/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.suggestions;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.ItemWrapper;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.MouseButton;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.StringConverter;

class SuggestionsPopup<T>
extends Popup {
    private final ListView<ItemWrapper<T>> suggestionList;
    protected final ComboBox<T> comboBox;
    private final SuggestionsHandler<T> suggestionsHandler;

    SuggestionsPopup(ComboBox<T> cb, SuggestionsHandler<T> handler) {
        this.comboBox = cb;
        this.suggestionsHandler = handler;
        this.setAutoFix(true);
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.suggestionList = new ListView();
        this.suggestionList.prefHeightProperty().bind((ObservableValue)Bindings.min((int)10, (ObservableNumberValue)Bindings.size((ObservableList)this.suggestionList.getItems())).multiply(24).add(18));
        this.suggestionList.setMinHeight(Double.NEGATIVE_INFINITY);
        this.suggestionList.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.suggestionList.setCellFactory(TextFieldListCell.forListView((StringConverter)new StringConverter<ItemWrapper<T>>(){

            public String toString(ItemWrapper<T> object) {
                switch (object.type) {
                    case LOADING: {
                        return Messages.General_Looking_for_variants;
                    }
                    case NO_DATA: {
                        return Messages.General_Variants_not_found;
                    }
                }
                return SuggestionsPopup.this.comboBox.getConverter().toString(object.item);
            }

            public ItemWrapper<T> fromString(String string) {
                return null;
            }
        }));
        this.suggestionList.prefWidthProperty().bind((ObservableValue)this.comboBox.widthProperty());
        this.suggestionList.setMinWidth(Double.NEGATIVE_INFINITY);
        this.suggestionList.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.suggestionList.setOnMouseClicked(me -> {
            ItemWrapper item;
            if (me.getButton() == MouseButton.PRIMARY && (item = (ItemWrapper)this.suggestionList.getSelectionModel().getSelectedItem()) != null) {
                this.select(item);
            }
        });
        this.suggestionList.setOnKeyPressed(evt -> {
            switch (evt.getCode()) {
                case TAB: 
                case ENTER: {
                    ItemWrapper item = (ItemWrapper)this.suggestionList.getSelectionModel().getSelectedItem();
                    if (item == null && !this.suggestionList.getItems().isEmpty()) {
                        item = (ItemWrapper)this.suggestionList.getItems().get(0);
                    }
                    this.select(item);
                    break;
                }
                case ESCAPE: {
                    this.hide();
                    break;
                }
            }
        });
        this.getContent().add(this.suggestionList);
    }

    private void select(ItemWrapper<T> item) {
        if (item == null) {
            this.comboBox.setValue(null);
            this.suggestionsHandler.onSuggestionSelected(null);
            return;
        }
        if (item.type != ItemWrapper.Type.VALUE) {
            return;
        }
        this.comboBox.getEditor().setText(this.comboBox.getConverter().toString(item.item));
        this.comboBox.setValue(item.item);
        this.comboBox.getEditor().positionCaret(this.comboBox.getEditor().getText().length());
        this.comboBox.getEditor().selectAll();
        this.hide();
        this.suggestionsHandler.onSuggestionSelected(item.item);
    }

    void loading() {
        this.suggestionList.getItems().setAll((Object[])new ItemWrapper[]{new ItemWrapper(ItemWrapper.Type.LOADING)});
        this.show((Node)this.comboBox);
    }

    void setSuggestions(List<T> items) {
        if (items.isEmpty()) {
            this.suggestionList.getItems().setAll((Object[])new ItemWrapper[]{new ItemWrapper(ItemWrapper.Type.NO_DATA)});
        } else {
            this.suggestionList.getItems().setAll((Collection)items.stream().map(item -> new ItemWrapper<Object>(item)).collect(Collectors.toList()));
        }
        this.show((Node)this.comboBox);
    }

    private void show(Node node) {
        if (this.comboBox.getScene() == null) {
            return;
        }
        this.sizeToScene();
        if (this.isShowing()) {
            return;
        }
        Window parent = node.getScene().getWindow();
        this.show(parent, parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + 28.0);
    }
}

