/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.suggestions;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.AsyncKeyHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.BaseKeyHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SyncKeyHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.model.Xeption;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;

public final class SuggestionsSupport {
    public static <T> void installSuggestions(ComboBox<T> comboBox, SuggestionsHandler<T> suggestionsHandler) {
        Object value = comboBox.getValue();
        comboBox.setEditable(true);
        comboBox.setValue(value);
        TextField editor = comboBox.getEditor();
        editor.focusedProperty().addListener((s, o, n) -> {
            if (n.booleanValue()) {
                FxUtil.submitToFxThread(() -> ((TextField)editor).selectAll());
            }
        });
        final StringConverter converter = comboBox.getConverter();
        comboBox.setConverter(new StringConverter<T>(){

            public String toString(T object) {
                return converter == null ? (object == null ? "" : object.toString()) : converter.toString(object);
            }

            public T fromString(String string) {
                throw Xeption.forDeveloper((String)"fake error", (Object[])new Object[0]);
            }
        });
        BaseKeyHandler handler = suggestionsHandler.isAsync() ? new AsyncKeyHandler<T>(comboBox, suggestionsHandler) : new SyncKeyHandler<T>(comboBox, suggestionsHandler);
        comboBox.setOnKeyReleased(handler);
        comboBox.parentProperty().addListener((s, o, n) -> {
            if (n == null) {
                handler.dispose();
            }
        });
    }

    public static <T> void uninstallSuggestions(ComboBox<T> comboBox) {
        TextField editor = comboBox.getEditor();
        if (editor != null) {
            EventHandler handler = editor.getOnKeyReleased();
            if (handler instanceof BaseKeyHandler) {
                ((BaseKeyHandler)handler).dispose();
            }
            editor.setOnKeyReleased(null);
        }
        Object value = comboBox.getValue();
        comboBox.setEditable(false);
        comboBox.setValue(value);
    }

    private SuggestionsSupport() {
    }
}

