/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.table;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableViewSkin;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class CustomTableView<I>
extends TableView<I> {
    static final double MIN_COLUMN_WIDTH = 25.0;
    private static final PseudoClass INTERLACING_HIGHLIGHT_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"interlacing");
    private static final double MIN_COLUMN_WIDTH_THRESHOLD = 20.0;
    private static final String UNRESIZABLE_STYLE = "unresizable";
    private static final EventHandler<? super MouseEvent> eventMuter = Event::consume;
    private TableActionHandler<I> actionHandler;

    public static Callback<TableView.ResizeFeatures, Boolean> getConstrainedResizePolicy() {
        return param -> {
            try {
                Field field = TableView.CONSTRAINED_RESIZE_POLICY.getClass().getDeclaredField("isFirstRun");
                field.setAccessible(true);
                field.set(TableView.CONSTRAINED_RESIZE_POLICY, Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (Boolean)TableView.CONSTRAINED_RESIZE_POLICY.call(param);
        };
    }

    public CustomTableView() {
        this.getStyleClass().addAll((Object[])new String[]{"custom-table-view", "xtrip-scroll-alt"});
        this.setPlaceholder((Node)new Label(Messages.General_No_data_for_view));
        this.widthProperty().addListener(obj -> this.updateResizePolicy());
        this.getColumns().addListener(src -> {
            this.initReorderRestriction();
            this.initResizeRestrictions();
            this.setColumnsSortableStyle();
            this.setColumnsMinWidth();
            this.sortByFirstColumn();
            Styles.addStyle((Styleable)this.getColumns().get(0), "first-column");
        });
    }

    public TableColumn<I, ?> findColumn(String id) {
        return this.getColumns().stream().filter(col -> id.equals(col.getId())).findFirst().orElse(null);
    }

    public TableActionHandler<I> getActionHandler() {
        return this.actionHandler;
    }

    public void setActionHandler(TableActionHandler<I> value) {
        this.actionHandler = value;
        this.refresh();
    }

    public void setInterlacingHighlight(boolean value) {
        this.pseudoClassStateChanged(INTERLACING_HIGHLIGHT_PSEUDOCLASS, value);
    }

    private void setColumnsSortableStyle() {
        this.getColumns().stream().filter(TableColumnBase::isSortable).forEach(column -> Styles.addStyle((Styleable)column, "sortable"));
    }

    private void setColumnsMinWidth() {
        this.getColumns().stream().filter(column -> column.getMinWidth() < 20.0).forEach(column -> column.setMinWidth(25.0));
    }

    private void sortByFirstColumn() {
        if (this.getColumns().isEmpty() || !this.getSortOrder().isEmpty()) {
            return;
        }
        Optional<TableColumn> opt = this.getColumns().stream().filter(TableColumnBase::isSortable).findFirst();
        if (opt.isPresent()) {
            this.getSortOrder().add((Object)opt.get());
            opt.get().setSortType(TableColumn.SortType.ASCENDING);
        }
    }

    private void updateResizePolicy() {
        double totalColumnsWidth = this.getColumns().stream().collect(Collectors.summarizingDouble(TableColumnBase::getPrefWidth)).getSum();
        if (totalColumnsWidth < this.getWidth() || !TableView.UNCONSTRAINED_RESIZE_POLICY.equals(this.getColumnResizePolicy())) {
            this.setColumnResizePolicy(CustomTableView.getConstrainedResizePolicy());
        } else {
            this.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        }
    }

    private TableHeaderRow getTableHeaderRow() {
        if (this.getSkin() == null) {
            this.setSkin(this.createDefaultSkin());
        }
        return (TableHeaderRow)((TableViewSkin)this.getSkin()).getChildren().stream().filter(node -> node instanceof TableHeaderRow).findFirst().get();
    }

    private void updateResizeRestrictions() {
        this.getColumns().forEach(column -> {
            if (column.getMinWidth() == column.getMaxWidth() || !column.isResizable()) {
                Styles.addStyle((Styleable)column, UNRESIZABLE_STYLE);
                this.addInterceptors((TableColumn<I, ?>)column);
            } else {
                Styles.removeStyle((Styleable)column, UNRESIZABLE_STYLE);
                this.removeInterceptors((TableColumn<I, ?>)column);
            }
        });
    }

    private Map<TableColumn<I, ?>, Rectangle> getDragRects() {
        try {
            Field dragRectsField = NestedTableColumnHeader.class.getDeclaredField("dragRects");
            dragRectsField.setAccessible(true);
            return (Map)dragRectsField.get(this.getTableHeaderRow().getRootHeader());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            ErrorHandler.handle(e);
            return null;
        }
    }

    private void addInterceptors(TableColumn<I, ?> column) {
        Rectangle rect = this.getDragRects().get(column);
        if (rect != null) {
            rect.setOnMouseEntered(eventMuter);
            rect.setOnMousePressed(eventMuter);
            rect.setOnMouseDragged(eventMuter);
        } else if (this.getColumns().indexOf(column) == this.getColumns().size() - 1) {
            this.addInterceptors(this.getLastVisibleColumn());
        }
    }

    private void removeInterceptors(TableColumn<I, ?> column) {
        Rectangle rect = this.getDragRects().get(column);
        if (rect != null) {
            rect.removeEventHandler(MouseEvent.MOUSE_ENTERED, eventMuter);
            rect.removeEventHandler(MouseEvent.MOUSE_DRAGGED, eventMuter);
            rect.removeEventHandler(MouseEvent.MOUSE_PRESSED, eventMuter);
        }
    }

    private TableColumn<I, ?> getLastVisibleColumn() {
        TableColumn lastVisibleColumn = null;
        int i = this.getColumns().size() - 1;
        while (lastVisibleColumn == null && i-- > 0) {
            if (!((TableColumn)this.getColumns().get(i)).isVisible()) continue;
            lastVisibleColumn = (TableColumn)this.getColumns().get(i);
        }
        return lastVisibleColumn;
    }

    private void initResizeRestrictions() {
        this.getColumns().forEach(column -> column.visibleProperty().addListener(o -> this.updateResizeRestrictions()));
        this.getTableHeaderRow().getRootHeader().widthProperty().addListener(o -> this.updateResizeRestrictions());
    }

    private void initReorderRestriction() {
        this.getTableHeaderRow().getRootHeader().getColumnHeaders().addListener(change -> {
            change.next();
            change.getAddedSubList().forEach(columnHeader -> {
                columnHeader.setOnMousePressed(Event::consume);
                columnHeader.setOnMouseDragged(Event::consume);
            });
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new CustomTableViewSkin(this);
    }
}

