/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.table;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.components.text.RichTextFlow;
import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.function.Function;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class TableCellFactory<I>
implements Callback<TableColumn<I, Object>, TableCell<I, Object>> {
    public TableCell<I, Object> call(TableColumn<I, Object> column) {
        boolean numeric;
        TableColumnSettings sett = (TableColumnSettings)column.getUserData();
        if ("boolean".equalsIgnoreCase(sett.getType())) {
            return new BooleanPropTableCell();
        }
        if (sett.getType() == null) {
            numeric = false;
        } else {
            switch (sett.getType()) {
                case "int": 
                case "Integer": 
                case "java.lang.Integer": 
                case "long": 
                case "Long": 
                case "java.lang.Long": 
                case "double": 
                case "Double": 
                case "java.lang.Double": 
                case "float": 
                case "Float": 
                case "java.lang.Float": 
                case "java.math.BigInteger": 
                case "java.math.BigDecimal": {
                    numeric = true;
                    break;
                }
                default: {
                    numeric = false;
                }
            }
        }
        return new RendererPropTableCell(sett.getRenderer() == null ? StandardRenderers.GENERIC : sett.getRenderer(), numeric);
    }

    private static class RendererPropTableCell<I>
    extends TableCell<I, Object> {
        private final Function<Object, String> renderer;
        private Label label;
        private HyperlinkWidget linkWidget;
        private RichTextFlow textWidget;

        RendererPropTableCell(Function<Object, String> r, boolean numeric) {
            this.renderer = r;
            if (numeric) {
                this.getStyleClass().add((Object)"numeric");
            }
            this.setMaxHeight(Double.NEGATIVE_INFINITY);
            this.setMinHeight(Double.NEGATIVE_INFINITY);
        }

        protected void updateItem(Object item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setPrefHeight(-1.0);
                this.setGraphic(null);
                return;
            }
            String value = this.renderer.apply(item);
            TableActionHandler<Object> actionHandler = ((CustomTableView)this.getTableView()).getActionHandler();
            if (actionHandler == null || this.getTableRow() == null || !actionHandler.isActive(this.getTableColumn(), this.getTableRow().getItem())) {
                this.linkWidget = null;
                if (value != null && (value.startsWith("<html>") || value.startsWith("<HTML>"))) {
                    if (this.textWidget == null) {
                        this.textWidget = new RichTextFlow(TextHandler.SIMPLE_HTML);
                        this.textWidget.layoutBoundsProperty().addListener((v, o, n) -> this.adjustHeight());
                    }
                    this.textWidget.setText(value);
                    double initialScale = 2.25;
                    this.setPrefHeight(this.textWidget.prefHeight(this.getTableColumn().getWidth()) * initialScale + 4.0);
                    this.setGraphic((Node)this.textWidget);
                } else {
                    this.setPrefHeight(-1.0);
                    if (this.label == null) {
                        this.label = new CustomLabel();
                    }
                    this.label.setText(TextUtil.isBlank((String)value) ? "\u2014" : value);
                    this.setGraphic((Node)this.label);
                }
                return;
            }
            this.setPrefHeight(-1.0);
            if (this.linkWidget == null) {
                this.linkWidget = new HyperlinkWidget();
                this.linkWidget.setOnAction(this::onAction);
            }
            this.linkWidget.setText(TextUtil.isBlank((String)value) ? "\u2014" : value);
            this.setGraphic((Node)this.linkWidget);
        }

        private void adjustHeight() {
            if (this.getScene() == null) {
                return;
            }
            this.setPrefHeight(this.textWidget.prefHeight(this.getTableColumn().getWidth()) + 4.0);
            FxUtil.submitToFxThread(() -> ((RendererPropTableCell)this).requestLayout());
        }

        private void onAction(ActionEvent evt) {
            TableActionHandler<Object> actionHandler = ((CustomTableView)this.getTableView()).getActionHandler();
            if (actionHandler != null) {
                actionHandler.onAction(this.getTableColumn(), this.getTableRow().getItem());
            }
        }
    }

    private static class BooleanPropTableCell<I>
    extends TableCell<I, Object> {
        private VBox vbox;

        BooleanPropTableCell() {
        }

        protected void updateItem(Object item, boolean empty) {
            super.updateItem(item, empty);
            this.setText(null);
            if (empty || item == null) {
                this.setGraphic(null);
                return;
            }
            IconNode icon = Boolean.TRUE.equals(item) ? new IconNode(StandardIconShapes.TABLE_FLAG_ON_12x12, (Styleable)this.getTableRow(), StandardIconIntentions.TABLE_FLAG_ACTION, (Styleable)this.getTableRow()) : new IconNode(StandardIconShapes.TABLE_FLAG_OFF_12x12, (Styleable)this.getTableRow(), StandardIconIntentions.TABLE_FLAG_ACTION, (Styleable)this.getTableRow());
            if (this.vbox == null) {
                this.vbox = new VBox(new Node[]{icon});
                this.vbox.setAlignment(Pos.CENTER);
            } else {
                this.vbox.getChildren().setAll((Object[])new Node[]{icon});
            }
            this.setGraphic((Node)this.vbox);
        }
    }
}

