/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.table;

import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableCellFactory;
import com.gridnine.xtrip.client.fx.core.registry.basic.Icon;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;

public class TableColumnSettings {
    private static final ObservableValue<Object> NULL_OBJECT_WRAPPER = new ReadOnlyObjectWrapper();
    private static final TableCellFactory<?> CELL_FACTORY = new TableCellFactory();
    private String id;
    private String displayName;
    private String type;
    private Icon icon;
    private Double prefWidth;
    private Renderer renderer;
    private boolean sortable = true;

    public static TableColumnSettings getFor(TableColumn<?, ?> column) {
        Object result = column.getUserData();
        return result instanceof TableColumnSettings ? (TableColumnSettings)result : null;
    }

    public static <T> TableColumn<T, Object> createActionColumn(Consumer<T> handler) {
        return TableColumnSettings.createActionColumn(handler, StandardIconShapes.BOX_NAVIGATE);
    }

    public static <T> TableColumn<T, Object> createActionColumn(final Consumer<T> handler, final IconShape icon) {
        TableColumn result = new TableColumn();
        result.setMinWidth(40.0);
        result.setPrefWidth(40.0);
        result.setMaxWidth(40.0);
        result.setSortable(false);
        result.setResizable(false);
        result.setCellFactory(colulm -> new TableCell<T, Object>(){
            private Button button;

            protected void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                this.setText(null);
                if (empty) {
                    this.setGraphic(null);
                    return;
                }
                if (this.button == null) {
                    this.button = new Button();
                    this.button.setGraphic((Node)new IconNode(icon, (Styleable)this.button, StandardIconIntentions.BOX_NAVIGATE_BUTTON_ACTION, (Styleable)this.button));
                    this.button.getStyleClass().add((Object)"xtrip-button");
                    this.button.setOnAction(evt -> handler.accept(this.getTableRow().getItem()));
                }
                this.setGraphic((Node)this.button);
            }
        });
        return result;
    }

    public static void setHelp(TableColumn<?, ?> col, Supplier<QuickHelp> supplier) {
        Styles.addStyle(col, "hasTooltip");
        StackPane wrap = new StackPane(new Node[]{Buttons.quickHelpButton(supplier)});
        wrap.getStyleClass().add((Object)"wrap");
        wrap.setAlignment(Pos.CENTER);
        col.setGraphic((Node)wrap);
    }

    public static void configureSorting(TableColumn<?, ?> column, boolean sortable) {
        column.setSortable(sortable);
        if (!sortable) {
            return;
        }
        FxUtil.addListener(column.sortTypeProperty(), (s, o, n) -> {
            IconNode sortNode;
            TableColumn.SortType sortType = column.getSortType();
            if (sortType == null) {
                sortNode = new IconNode(StandardIconShapes.TABLE_SORT_NOT_14x14, null, StandardIconIntentions.TABLE_SORT_ACTION, null);
            } else {
                switch (sortType) {
                    case ASCENDING: {
                        sortNode = new IconNode(StandardIconShapes.TABLE_SORT_ASC_14x14, null, StandardIconIntentions.TABLE_SORT_ACTION, null);
                        break;
                    }
                    case DESCENDING: {
                        sortNode = new IconNode(StandardIconShapes.TABLE_SORT_DESC_14x14, null, StandardIconIntentions.TABLE_SORT_ACTION, null);
                        break;
                    }
                    default: {
                        sortNode = new IconNode(StandardIconShapes.TABLE_SORT_NOT_14x14, null, StandardIconIntentions.TABLE_SORT_ACTION, null);
                    }
                }
            }
            column.setSortNode((Node)sortNode);
        });
    }

    private static void configurePrefWidth(TableColumn<?, ?> col) {
        col.setResizable(true);
        col.setMinWidth(25.0);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String value) {
        this.displayName = value;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon value) {
        this.icon = value;
    }

    public Double getPrefWidth() {
        return this.prefWidth;
    }

    public void setPrefWidth(Double value) {
        this.prefWidth = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer value) {
        this.renderer = value;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean value) {
        this.sortable = value;
    }

    public <I> TableColumn<I, Object> createColumn(Function<I, Object> cellValueProvider) {
        TableColumn result = new TableColumn(this.getDisplayName());
        result.setCellFactory(CELL_FACTORY);
        result.setCellValueFactory(param -> {
            Object item = param.getValue();
            if (item == null) {
                return NULL_OBJECT_WRAPPER;
            }
            return new ReadOnlyObjectWrapper(cellValueProvider.apply(item));
        });
        result.setId(this.getId());
        result.setUserData((Object)this);
        if (this.getPrefWidth() != null && this.getPrefWidth() > 0.0) {
            result.setPrefWidth(this.getPrefWidth().doubleValue());
            result.setMaxWidth(this.getPrefWidth().doubleValue());
            result.setMinWidth(this.getPrefWidth().doubleValue());
        } else {
            TableColumnSettings.configurePrefWidth(result);
        }
        if (this.getIcon() != null) {
            result.setGraphic((Node)new ImageView(this.getIcon().getImage()));
            result.setText(null);
        }
        TableColumnSettings.configureSorting(result, this.sortable);
        return result;
    }
}

