/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.tree;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class CustomTreeView<T>
extends TreeView<T> {
    private static final PseudoClass AFTER_SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"afterselected");
    private static final PseudoClass BEFORE_SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"beforeselected");
    StringConverter<T> converter = StandardRenderers.GENERIC.createConverter(() -> "");
    Function<TreeItem<T>, IconShape> iconSupplier;
    Function<TreeItem<T>, List<String>> styleSupplier;
    Function<TreeItem<T>, List<MenuItem>> menuItemsSupplier;
    final List<ControlButton<T>> controlButtons = new ArrayList<ControlButton<T>>();
    protected final Callback<TreeView<T>, TreeCell<T>> callback = tv -> new TreeCell<T>(){
        private CellPane pane;
        {
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.hoverProperty().addListener(src -> {
                if (this.pane != null) {
                    this.pane.update();
                }
            });
            this.hoverProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    TreeItem item = this.getTreeItem();
                    int row = this.getTreeView().getRow(item);
                    TreeItem previousTreeItem = this.getTreeView().getTreeItem(row - 1);
                    TreeItem nextTreeItem = this.getTreeView().getTreeItem(row + 1);
                    this.pseudoClassStateChanged(BEFORE_SELECTED_PSEUDOCLASS_STATE, nextTreeItem != null && CustomTreeView.this.getSelectionModel().getSelectedItem() == nextTreeItem);
                    this.pseudoClassStateChanged(AFTER_SELECTED_PSEUDOCLASS_STATE, previousTreeItem != null && CustomTreeView.this.getSelectionModel().getSelectedItem() == previousTreeItem);
                } else {
                    this.pseudoClassStateChanged(BEFORE_SELECTED_PSEUDOCLASS_STATE, false);
                    this.pseudoClassStateChanged(AFTER_SELECTED_PSEUDOCLASS_STATE, false);
                }
            });
        }

        public void updateItem(T value, boolean empty) {
            super.updateItem(value, empty);
            this.setDisclosureNode(null);
            this.setText(null);
            TreeItem item = this.getTreeItem();
            if (empty || item == null) {
                this.setGraphic(null);
                return;
            }
            if (this.pane == null) {
                this.pane = new CellPane(this);
            }
            this.pane.update();
            this.setGraphic((Node)this.pane);
        }
    };

    public CustomTreeView() {
        this.getStyleClass().setAll((Object[])new String[]{"xtrip-tree-view"});
        this.setCellFactory(this.callback);
    }

    public void setConverter(StringConverter<T> value) {
        this.converter = Objects.requireNonNull(value);
    }

    public void setIconSupplier(Function<TreeItem<T>, IconShape> value) {
        this.iconSupplier = value;
    }

    public void setStyleSupplier(Function<TreeItem<T>, List<String>> value) {
        this.styleSupplier = value;
    }

    public List<ControlButton<T>> getControlButtons() {
        return this.controlButtons;
    }

    public void setMenuItemsSupplier(Function<TreeItem<T>, List<MenuItem>> menuItemsSupplier) {
        this.menuItemsSupplier = menuItemsSupplier;
    }

    private class CellPane
    extends StackPane {
        private final TreeCell<T> treeCell;
        private final IconNode imageIcon;
        private final Label titleLabel;
        private final IconNode rulerButtonIcon;
        private HBox controlsPane;
        private final List<String> titleLabelStyles = new ArrayList<String>();

        CellPane(TreeCell<T> cell) {
            this.treeCell = cell;
            this.imageIcon = new IconNode(StandardIconShapes.UNDEFINED, (Styleable)cell, StandardIconIntentions.TREE_CELL_DECORATION, (Styleable)cell);
            this.imageIcon.getStyleClass().add((Object)"image-icon");
            this.imageIcon.setMaxWidth(Double.NEGATIVE_INFINITY);
            this.imageIcon.setMinWidth(Double.NEGATIVE_INFINITY);
            this.titleLabel = new CustomLabel();
            this.titleLabel.getStyleClass().add((Object)"title-label");
            this.titleLabel.setMaxWidth(Double.MAX_VALUE);
            GridPane.setHgrow((Node)this.titleLabel, (Priority)Priority.ALWAYS);
            this.rulerButtonIcon = new IconNode(StandardIconShapes.RULER_14X14, (Styleable)cell, StandardIconIntentions.TREE_CELL_BUTTON_RULER, (Styleable)cell);
            this.rulerButtonIcon.getStyleClass().add((Object)"button-icon");
            this.rulerButtonIcon.setMaxWidth(Double.NEGATIVE_INFINITY);
            this.rulerButtonIcon.setMinWidth(Double.NEGATIVE_INFINITY);
            this.rulerButtonIcon.setOnMousePressed(evt -> {
                evt.consume();
                TreeItem item = this.treeCell.getTreeItem();
                item.setExpanded(!item.isExpanded());
            });
            GridPane gp = new GridPane();
            gp.setMaxWidth(Double.MAX_VALUE);
            gp.addRow(0, new Node[]{this.imageIcon, this.titleLabel, this.rulerButtonIcon});
            this.getChildren().add((Object)gp);
        }

        void update() {
            if (this.treeCell.isEmpty()) {
                return;
            }
            TreeItem item = this.treeCell.getTreeItem();
            if (item == null) {
                return;
            }
            this.rulerButtonIcon.setVisible(!item.isLeaf());
            if (CustomTreeView.this.iconSupplier != null) {
                this.imageIcon.setIconShape(CustomTreeView.this.iconSupplier.apply(item));
            }
            this.titleLabel.getStyleClass().removeAll(this.titleLabelStyles);
            if (CustomTreeView.this.styleSupplier != null) {
                this.titleLabelStyles.clear();
                this.titleLabelStyles.addAll((Collection<String>)CustomTreeView.this.styleSupplier.apply(item));
            }
            this.titleLabel.getStyleClass().addAll(this.titleLabelStyles);
            this.titleLabel.setText(CustomTreeView.this.converter.toString(item.getValue()));
            if (!this.treeCell.isHover() || CustomTreeView.this.controlButtons.isEmpty()) {
                if (this.controlsPane != null) {
                    this.getChildren().remove((Object)this.controlsPane);
                    this.controlsPane = null;
                }
                return;
            }
            this.titleLabel.setOnContextMenuRequested(evt -> {
                CustomContextMenu menu = new CustomContextMenu();
                CustomMenuItem menuItem = new CustomMenuItem(Messages.General_Copy_text);
                menuItem.setOnAction(evt2 -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, this.titleLabel.getText())));
                menu.getItems().add((Object)menuItem);
                if (CustomTreeView.this.menuItemsSupplier != null) {
                    menu.getItems().addAll((Collection)CustomTreeView.this.menuItemsSupplier.apply(item));
                }
                menu.show((Node)this, evt.getScreenX(), evt.getScreenY());
            });
            if (this.controlsPane == null) {
                this.controlsPane = new HBox();
                this.controlsPane.setMaxWidth(Double.NEGATIVE_INFINITY);
                StackPane.setMargin((Node)this.controlsPane, (Insets)new Insets(0.0, this.rulerButtonIcon.getWidth() + 5.0, 0.0, 0.0));
                StackPane.setAlignment((Node)this.controlsPane, (Pos)Pos.CENTER_RIGHT);
                this.getChildren().add((Object)this.controlsPane);
            }
            ArrayList<IconNode> nodes = new ArrayList<IconNode>(CustomTreeView.this.controlButtons.size());
            for (ControlButton button : CustomTreeView.this.controlButtons) {
                if (!button.isAvailable(item)) continue;
                IconNode buttonIcon = new IconNode(button.getIconShape(), (Styleable)this.treeCell, button.getIconIntention(), (Styleable)this.treeCell);
                buttonIcon.getStyleClass().add((Object)"button-icon");
                Tooltip.install((Node)buttonIcon, (Tooltip)new Tooltip(button.getDescription()));
                buttonIcon.setOnMousePressed(evt -> {
                    evt.consume();
                    button.onAction(this.treeCell.getTreeItem());
                });
                buttonIcon.setDisable(!button.isEnabled(item));
                nodes.add(buttonIcon);
            }
            this.controlsPane.getChildren().setAll(nodes);
        }
    }

    public static interface ControlButton<T> {
        public IconShape getIconShape();

        public IconIntention getIconIntention();

        public String getDescription();

        public boolean isAvailable(TreeItem<T> var1);

        public boolean isEnabled(TreeItem<T> var1);

        public void onAction(TreeItem<T> var1);
    }
}

