/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.tree;

import java.lang.reflect.Field;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;

public class FilterableTreeItem<T>
extends TreeItem<T> {
    private final ObservableList<TreeItem<T>> internalChildren;
    private final FilteredList<TreeItem<T>> filteredChildren;
    private final ObjectProperty<Predicate<T>> predicate = new SimpleObjectProperty();
    private final BooleanProperty ignoreFilterOnce = new SimpleBooleanProperty();
    private boolean filtered;

    public FilterableTreeItem() {
        this(null, null);
    }

    public FilterableTreeItem(T value) {
        this(value, null);
    }

    public FilterableTreeItem(T value, Node graphic) {
        super(value, graphic);
        this.internalChildren = FXCollections.observableArrayList();
        this.filteredChildren = new FilteredList(this.internalChildren);
        this.filteredChildren.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            Predicate<TreeItem> p = childItem -> {
                if (childItem instanceof FilterableTreeItem) {
                    FilterableTreeItem filterableChildItem = (FilterableTreeItem)((Object)((Object)childItem));
                    filterableChildItem.setPredicate(this.getPredicate());
                    if (filterableChildItem.isIgnoreFilterOnce()) {
                        filterableChildItem.setIgnoreFilterOnce(false);
                        this.filtered = false;
                        return true;
                    }
                }
                if (this.getPredicate() == null) {
                    this.filtered = false;
                    return true;
                }
                if (childItem.getChildren().size() > 0) {
                    this.filtered = false;
                    return true;
                }
                this.filtered = !this.getPredicate().test(childItem.getValue());
                return !this.filtered;
            };
            return p;
        }, (Observable[])new Observable[]{this.predicateProperty()}));
        this.setHiddenFieldChildren((ObservableList<TreeItem<T>>)this.filteredChildren);
    }

    protected void setHiddenFieldChildren(ObservableList<TreeItem<T>> list) {
        try {
            Field childrenField = TreeItem.class.getDeclaredField("children");
            if (!childrenField.isAccessible()) {
                childrenField.setAccessible(true);
            }
            childrenField.set((Object)this, list);
            Field listenerField = TreeItem.class.getDeclaredField("childrenListener");
            if (!listenerField.isAccessible()) {
                listenerField.setAccessible(true);
            }
            list.addListener((ListChangeListener)listenerField.get((Object)this));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set TreeItem.children", e);
        }
    }

    public ObservableList<TreeItem<T>> getInternalChildren() {
        return this.internalChildren;
    }

    public final ObjectProperty<Predicate<T>> predicateProperty() {
        return this.predicate;
    }

    public final void setPredicate(Predicate<T> value) {
        this.predicate.set(value);
    }

    public final Predicate<T> getPredicate() {
        return (Predicate)this.predicate.get();
    }

    public final BooleanProperty ignoreFilterOnceProperty() {
        return this.ignoreFilterOnce;
    }

    public final void setIgnoreFilterOnce(boolean value) {
        this.ignoreFilterOnce.set(value);
    }

    public final boolean isIgnoreFilterOnce() {
        return this.ignoreFilterOnce.get();
    }

    public boolean isFiltered() {
        return this.filtered;
    }
}

