/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class SimpleContainer<N extends Node>
extends VBox
implements DevTool {
    private final StringProperty caption = new SimpleStringProperty(){

        protected void invalidated() {
            SimpleContainer.this.updateState();
        }
    };
    private final ObjectProperty<N> content = new SimpleObjectProperty<N>(){

        protected void invalidated() {
            Node node = (Node)this.get();
            if (node != null) {
                VBox.setVgrow((Node)node, (Priority)Priority.ALWAYS);
            }
            SimpleContainer.this.updateState();
        }
    };

    public static <N extends Node> SimpleContainer<N> create(N content) {
        SimpleContainer<N> result = new SimpleContainer<N>();
        result.setContent(content);
        return result;
    }

    public SimpleContainer() {
        this.getStyleClass().add((Object)"simple-container");
    }

    protected void updateState() {
        Styles.manageStyle((Styleable)this, "adopts-widget", this.content.getValue() != null && ((Node)this.content.getValue()).getStyleClass().contains((Object)"simple-widget"));
        if (this.caption.get() == null) {
            if (this.content.get() == null) {
                this.getChildren().clear();
            } else {
                this.getChildren().setAll((Object[])new Node[]{(Node)this.content.get()});
            }
        } else {
            Label label = new Label((String)this.caption.get());
            label.getStyleClass().add((Object)"caption");
            if (this.content.get() == null) {
                this.getChildren().setAll((Object[])new Node[]{label});
            } else {
                this.getChildren().setAll((Object[])new Node[]{label, (Node)this.content.get()});
            }
        }
    }

    public StringProperty captionProperty() {
        return this.caption;
    }

    public String getCaption() {
        return (String)this.caption.get();
    }

    public void setCaption(String value) {
        this.caption.set((Object)value);
    }

    public ObjectProperty<N> contentProperty() {
        return this.content;
    }

    public N getContent() {
        return (N)((Node)this.content.get());
    }

    public void setContent(N value) {
        this.content.set(value);
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                ArrayList<DevTool> result = new ArrayList<DevTool>(ControllersRegistry.buildDevToolsFor(SimpleContainer.this.getClass().getName() + "Controller"));
                result.add((DevTool)SimpleContainer.this.getContent());
                return result;
            }

            @Override
            public String getInfo() {
                return SimpleContainer.this.getClass().getSimpleName() + " [SimpleContainer]";
            }
        };
    }
}

