/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.cards;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardPane;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class CardsContainer
extends VBox
implements DevTool {
    private final ObservableList<Card<?>> cards = FXCollections.observableArrayList();
    private final ObservableList<Card<?>> forbiddenCards = FXCollections.observableArrayList();

    public CardsContainer() {
        this.getStyleClass().add((Object)"cards-container");
        this.cards.addListener(obj -> this.rebuild());
        this.forbiddenCards.addListener(obj -> this.rebuild());
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                this.rebuild();
            }
        });
    }

    public ObservableList<Card<?>> getCards() {
        return this.cards;
    }

    public ObservableList<Card<?>> getForbiddenCards() {
        return this.forbiddenCards;
    }

    void rebuild() {
        if (this.getScene() == null) {
            return;
        }
        if (this.cards.isEmpty()) {
            this.getChildren().clear();
            return;
        }
        boolean first = true;
        ArrayList<CardPane> panes = new ArrayList<CardPane>();
        for (Card card : this.cards) {
            card.setContainer(this);
            if (card.isHidden() || this.forbiddenCards.contains((Object)card)) continue;
            CardPane pane = card.getPane();
            pane.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, first);
            pane.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, false);
            first = false;
            pane.revalidateActions();
            if (card.isAdaptiveHeight()) {
                VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
            } else {
                VBox.setVgrow((Node)pane, null);
            }
            if (card.isCollapsible()) {
                if (card.isAdaptiveHeight()) {
                    pane.setMaxHeight(!card.isCollapsed() ? Double.MAX_VALUE : Double.NEGATIVE_INFINITY);
                } else {
                    pane.setMaxHeight(-1.0);
                }
            } else if (card.isAdaptiveHeight()) {
                pane.setMaxHeight(Double.MAX_VALUE);
            } else {
                pane.setMaxHeight(-1.0);
            }
            panes.add(pane);
        }
        if (!panes.isEmpty()) {
            ((Node)panes.get(panes.size() - 1)).pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, true);
        }
        this.getChildren().setAll(panes);
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                ArrayList<DevTool> result = new ArrayList<DevTool>(ControllersRegistry.buildDevToolsFor(CardsContainer.this.getClass().getName() + "Controller"));
                result.addAll((Collection<DevTool>)CardsContainer.this.getCards());
                return result;
            }

            @Override
            public String getInfo() {
                return CardsContainer.this.getClass().getSimpleName() + " [CardsContainer]";
            }
        };
    }
}

