/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.cells;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.BaseCell;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javafx.scene.Node;

public class ComplexCell<N extends Node>
extends BaseCell
implements DevTool {
    private N payload;

    public ComplexCell(N pl) {
        this.payload = (Node)Objects.requireNonNull(pl);
    }

    public N getPayload() {
        return this.payload;
    }

    public void setPayload(N value) {
        this.payload = (Node)Objects.requireNonNull(value);
        if (this.container != null && !this.isHidden()) {
            this.container.reflow();
        }
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.singletonList(ComplexCell.this.getPayload());
            }

            @Override
            public String getInfo() {
                String result = ComplexCell.this.getClass().getSimpleName();
                if (ComplexCell.this.isHidden()) {
                    result = result + " [hidden]";
                }
                if (ComplexCell.this.container != null && ComplexCell.this.container.getForbiddenCells().contains((Object)ComplexCell.this)) {
                    result = result + " [forbidden]";
                }
                return result;
            }
        };
    }
}

