/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.grid;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class GridContainer
extends GridPane
implements DevTool {
    private int maxColumnsCount = 1;
    private int columnsCount;
    private boolean adaptive;
    private final ObservableList<GridCell<?>> cells = FXCollections.observableArrayList();
    private final ObservableList<GridCell<?>> forbiddenCells = FXCollections.observableArrayList();

    public static GridContainer wrap(Node node) {
        return GridContainer.wrap(null, node);
    }

    public static GridContainer wrap(String caption, Node node) {
        GridContainer result = new GridContainer();
        result.cells.add(new GridCell<Node>(caption, node));
        return result;
    }

    public GridContainer() {
        this(1);
    }

    public GridContainer(int columns) {
        if (columns < 1) {
            throw new IllegalArgumentException("columns count should be positive");
        }
        this.maxColumnsCount = columns;
        this.getStyleClass().add((Object)"grid-container");
        this.widthProperty().addListener(obj -> {
            if (this.getScene() == null) {
                return;
            }
            int newCount = this.calculateColumnsCount();
            if (this.columnsCount != newCount) {
                this.columnsCount = newCount;
                this.reflow();
            }
        });
        this.cells.addListener(obj -> this.reflow());
        this.forbiddenCells.addListener(obj -> this.reflow());
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                this.reflow();
            }
        });
    }

    private int calculateColumnsCount() {
        if (!this.adaptive) {
            return this.maxColumnsCount;
        }
        double width = this.getWidth();
        if (width <= 400.0 || this.maxColumnsCount == 1) {
            return 1;
        }
        if (width <= 800.0 || this.maxColumnsCount == 2) {
            return 2;
        }
        if (width <= 1200.0 || this.maxColumnsCount == 3) {
            return 3;
        }
        if (width <= 1600.0 || this.maxColumnsCount == 4) {
            return 4;
        }
        if (width <= 2000.0 || this.maxColumnsCount == 5) {
            return 5;
        }
        return this.maxColumnsCount;
    }

    public int getColumnsCount() {
        return this.maxColumnsCount;
    }

    public void setColumnsCount(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("columns count should be positive");
        }
        this.maxColumnsCount = value;
        int newCount = this.calculateColumnsCount();
        if (this.columnsCount != newCount) {
            this.columnsCount = newCount;
            this.reflow();
        }
    }

    public boolean isAdaptive() {
        return this.adaptive;
    }

    public void setAdaptive(boolean value) {
        this.adaptive = value;
        int newCount = this.calculateColumnsCount();
        if (this.columnsCount != newCount) {
            this.columnsCount = newCount;
            this.reflow();
        }
    }

    public ObservableList<GridCell<?>> getCells() {
        return this.cells;
    }

    public ObservableList<GridCell<?>> getForbiddenCells() {
        return this.forbiddenCells;
    }

    void reflow() {
        if (this.getScene() == null) {
            return;
        }
        if (this.cells.isEmpty()) {
            this.getColumnConstraints().clear();
            this.getRowConstraints().clear();
            this.getChildren().clear();
            return;
        }
        if (this.columnsCount == 0) {
            this.columnsCount = this.calculateColumnsCount();
        }
        ArrayList<RowConstraints> rowConstraints = new ArrayList<RowConstraints>();
        ArrayList<ColumnConstraints> colConstraints = new ArrayList<ColumnConstraints>();
        ArrayList<Object> children = new ArrayList<Object>(this.cells.size());
        int row = 0;
        int col = 0;
        boolean newRow = true;
        for (GridCell cell : this.cells) {
            cell.setContainer(this);
            if (cell.isHidden() || this.forbiddenCells.contains((Object)cell)) continue;
            if (cell == GridCell.NEW_ROW_MARKER) {
                if (newRow) continue;
                newRow = true;
                ++row;
                continue;
            }
            if (newRow) {
                col = 0;
                RowConstraints rc = new RowConstraints(-1.0, -1.0, -1.0);
                rc.setValignment(VPos.TOP);
                rowConstraints.add(rc);
                rc = new RowConstraints(-1.0, -1.0, Double.MAX_VALUE);
                rc.setValignment(VPos.TOP);
                rowConstraints.add(rc);
                newRow = false;
            }
            HBox captionPane = new HBox();
            captionPane.getStyleClass().add((Object)"caption");
            cell.setCaptionPane(captionPane);
            GridPane.setHgrow((Node)captionPane, (Priority)Priority.ALWAYS);
            if (cell.getColSpan() > 1) {
                GridPane.setColumnSpan((Node)captionPane, (Integer)cell.getColSpan());
            }
            GridPane.setConstraints((Node)captionPane, (int)col, (int)(row * 2));
            children.add(captionPane);
            Object payload = cell.getPayload();
            GridPane.setConstraints(payload, (int)col, (int)(row * 2 + 1));
            if (cell.getColSpan() > 1) {
                GridPane.setColumnSpan(payload, (Integer)cell.getColSpan());
            } else {
                GridPane.setColumnSpan(payload, null);
            }
            if (cell.getRowSpan() > 1) {
                GridPane.setRowSpan(payload, (Integer)(cell.getRowSpan() * 2 - 1));
            } else {
                GridPane.setRowSpan(payload, null);
            }
            children.add(payload);
            if (cell.getColSpan() == Integer.MAX_VALUE || col + cell.getColSpan() - 1 >= this.columnsCount - 1) {
                newRow = true;
                ++row;
                continue;
            }
            col += cell.getColSpan();
        }
        if (!rowConstraints.isEmpty()) {
            ((RowConstraints)rowConstraints.get(rowConstraints.size() - 1)).setVgrow(Priority.ALWAYS);
        }
        double total = 0.0;
        for (int i = 0; i < this.columnsCount; ++i) {
            ColumnConstraints cc = new ColumnConstraints();
            double width = i == this.columnsCount - 1 ? 100.0 - total : 100.0 / (double)this.columnsCount;
            cc.setPercentWidth(width);
            colConstraints.add(cc);
            total += width;
        }
        this.getColumnConstraints().setAll(colConstraints);
        this.getRowConstraints().setAll(rowConstraints);
        this.getChildren().setAll(children);
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                ArrayList<DevTool> result = new ArrayList<DevTool>(ControllersRegistry.buildDevToolsFor(GridContainer.this.getClass().getName() + "Controller"));
                for (GridCell cell : GridContainer.this.getCells()) {
                    if (cell == GridCell.NEW_ROW_MARKER) continue;
                    result.add(cell);
                }
                return result;
            }

            @Override
            public String getInfo() {
                return GridContainer.this.getClass().getSimpleName() + " [GridContainer]";
            }
        };
    }
}

