/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.tiles;

import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.common.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class SpaceSettings
implements Serializable {
    private static final long serialVersionUID = -134441183719278162L;
    private static final int SAVE_DELAY = 1000;
    private final Map<String, Entry> data = new HashMap<String, Entry>();
    private final String spaceClassName;
    private transient boolean persistent;
    private transient boolean dirty;

    static SpaceSettings getFor(Class<? extends TilesSpace> cls) {
        SpaceSettings result = null;
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(SpaceSettings.getDataFile(cls.getName())));){
            result = (SpaceSettings)ois.readObject();
            result.persistent = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = new SpaceSettings(cls);
        }
        return result;
    }

    private static File getDataFile(String className) {
        File file = new File(Environment.getDataFolder(), "spaces/" + className + ".dat");
        return file;
    }

    private SpaceSettings(Class<? extends TilesSpace> cls) {
        this.spaceClassName = cls.getName();
    }

    boolean isOffScreen(String tileId) {
        Entry entry = this.data.get(tileId);
        return entry == null ? false : entry.offScreen;
    }

    void setOffScreen(String tileId, boolean value) {
        Entry entry = this.data.get(tileId);
        if (entry == null) {
            if (!value) {
                entry = new Entry();
                this.data.put(tileId, entry);
                entry.offScreen = value;
                this.dirty = true;
            }
        } else if (entry.offScreen != value) {
            entry.offScreen = value;
            this.dirty = true;
        }
        if (this.dirty) {
            Notifications.get().getScheduler().schedule(this::saveIfRequired, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    int getPosition(String tileId) {
        Entry entry = this.data.get(tileId);
        if (entry == null) {
            return 0;
        }
        if (entry.userPosition != null) {
            return entry.userPosition;
        }
        return entry.autoPosition == null ? 0 : entry.autoPosition;
    }

    void setPosition(String tileId, int value, boolean byUser) {
        Entry entry = this.data.get(tileId);
        if (entry == null) {
            entry = new Entry();
            this.data.put(tileId, entry);
        }
        if (byUser) {
            entry.userPosition = value;
        } else {
            entry.autoPosition = value;
        }
        if (this.persistent || byUser) {
            this.dirty = true;
            Notifications.get().getScheduler().schedule(this::saveIfRequired, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    private void saveIfRequired() {
        if (!this.dirty) {
            return;
        }
        this.persistent = true;
        File file = SpaceSettings.getDataFile(this.spaceClassName);
        file.getParentFile().mkdirs();
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
            oos.writeObject(this);
            this.dirty = false;
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = -7011160600110827161L;
        Integer autoPosition;
        Integer userPosition;
        boolean offScreen;

        Entry() {
        }
    }
}

