/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.tiles;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.ExtendedMessagePane;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomCheckMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.SpaceSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilePane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class TilesSpace
extends BorderPane
implements DevTool {
    protected final ObservableList<Tile<?, ?>> tiles = FXCollections.observableArrayList();
    protected TilePane<?, ?> overview;
    protected final ScrollPane mosaicScrollPane;
    protected final GridPane mosaicPane;
    private final StackPane stackPane;
    private int maxColumnsCount;
    private final ObservableList<Tile<?, ?>> hiddenTiles = FXCollections.observableArrayList();
    private final ObservableList<Tile<?, ?>> forbiddenTiles = FXCollections.observableArrayList();
    private int columnsCount;
    boolean superCompactMode = false;
    final SpaceSettings settings;
    private static final int[] WIDTHS_STANDARD = new int[]{900, 1300};
    private static final int[] WIDTHS_SUPER_COMPACT = new int[]{500, 700, 1000, 1300, 1600};

    public TilesSpace(int columns) {
        this.maxColumnsCount = columns;
        this.getStyleClass().add((Object)"tiles-space");
        this.settings = SpaceSettings.getFor(this.getClass());
        this.mosaicPane = new GridPane();
        this.mosaicPane.getStyleClass().add((Object)"mosaic-pane");
        this.mosaicScrollPane = new ScrollPane((Node)this.mosaicPane);
        this.mosaicScrollPane.getStyleClass().add((Object)"edge-to-edge");
        this.mosaicScrollPane.setFitToWidth(true);
        this.mosaicScrollPane.setFitToHeight(true);
        this.stackPane = new StackPane(new Node[]{this.mosaicScrollPane});
        this.stackPane.getStyleClass().add((Object)"tiles-pane");
        this.setCenter((Node)this.stackPane);
        this.tiles.addListener(obj -> this.requestLayout());
        this.hiddenTiles.addListener(obj -> this.requestLayout());
        this.forbiddenTiles.addListener(obj -> this.requestLayout());
        this.widthProperty().addListener(obj -> {
            if (this.getScene() == null) {
                return;
            }
            int newCount = this.calculateColumnsCount();
            if (this.columnsCount != newCount) {
                this.columnsCount = newCount;
                this.requestLayout();
            }
        });
    }

    public void setMaxColumnsCount(int value) {
        if (this.maxColumnsCount == value) {
            return;
        }
        this.maxColumnsCount = value;
        this.requestLayout();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.updateMosaic();
    }

    public void setOverview(Node node) {
        if (node == null) {
            this.overview = null;
        } else {
            Tile<Node, Object> tile = new Tile<Node, Object>("overview", Messages.General_Overview, node, null);
            tile.setSpace(this);
            this.overview = new TilePane<Node, Object>(tile, false);
        }
        this.requestLayout();
    }

    public void detuchHiddenNodes() {
        this.stackPane.getChildren().removeAll((Collection)this.stackPane.getChildren().stream().filter(node -> node != this.mosaicScrollPane && !node.isVisible()).collect(Collectors.toList()));
    }

    public void addTiles(Collection<Tile<?, ?>> newTiles) {
        if (!this.superCompactMode) {
            this.superCompactMode = this.tiles.size() + newTiles.size() > 1 && newTiles.stream().anyMatch(tile -> tile.getCompactNode() == null);
        }
        int pos = this.tiles.size();
        for (Tile<?, ?> tile2 : newTiles) {
            this.settings.setPosition(tile2.getId(), pos++, false);
            tile2.setSpace(this);
        }
        this.tiles.addAll(newTiles);
    }

    public void addTiles(Tile<?, ?> ... newTiles) {
        if (newTiles == null || newTiles.length == 0) {
            return;
        }
        if (!this.superCompactMode) {
            this.superCompactMode = this.tiles.size() + newTiles.length > 1 && Arrays.stream(newTiles).anyMatch(tile -> tile.getCompactNode() == null);
        }
        int pos = this.tiles.size();
        for (Tile<?, ?> tile2 : newTiles) {
            this.settings.setPosition(tile2.getId(), pos++, false);
            tile2.setSpace(this);
        }
        this.tiles.addAll((Object[])newTiles);
    }

    public List<Tile<?, ?>> getTiles() {
        return Collections.unmodifiableList(this.tiles);
    }

    public ObservableList<Tile<?, ?>> getHiddenTiles() {
        return this.hiddenTiles;
    }

    public ObservableList<Tile<?, ?>> getForbiddenTiles() {
        return this.forbiddenTiles;
    }

    public void expand(Tile<?, ?> tile) {
        if (tile.isExpanded() || this.hiddenTiles.contains(tile) || this.forbiddenTiles.contains(tile) || tile.getFullNode() == null) {
            return;
        }
        this.settings.setOffScreen(tile.getId(), false);
        this.setExpanded(tile, true);
    }

    public void revalidateActions() {
        if (this.mosaicScrollPane.isVisible()) {
            for (Tile tile : this.tiles) {
                TilePane pane = tile.getCollapsedPane();
                if (pane == null) continue;
                pane.revalidateActions();
            }
            return;
        }
        for (Tile tile : this.tiles) {
            TilePane pane;
            if (!tile.isExpanded() || (pane = tile.getExpandedPane()) == null) continue;
            pane.revalidateActions();
        }
    }

    public void addMessages(List<Message> messages) {
        if (messages.isEmpty()) {
            return;
        }
        VBox box = (VBox)this.getTop();
        if (box == null) {
            box = this.createMessagesPane();
            this.setTop((Node)box);
        }
        VBox boxFinal = box;
        for (Message message : messages) {
            MessagePane mp = MessagePane.forMessage(message);
            mp.makeClosable(() -> boxFinal.getChildren().remove((Object)mp));
            box.getChildren().add((Object)mp);
        }
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> void addMessages(Map<Message, IndexListParameters<E, I>> messages, String listTitle) {
        if (messages.isEmpty()) {
            return;
        }
        VBox box = (VBox)this.getTop();
        if (box == null) {
            box = this.createMessagesPane();
            this.setTop((Node)box);
        }
        VBox boxFinal = box;
        for (Map.Entry<Message, IndexListParameters<E, I>> set : messages.entrySet()) {
            if (set.getKey() == null) continue;
            ExtendedMessagePane mp = ExtendedMessagePane.forMessage(set.getKey(), set.getValue(), listTitle);
            mp.makeClosable(() -> boxFinal.getChildren().remove((Object)mp));
            box.getChildren().add((Object)mp);
        }
    }

    public void setMessages(List<Message> messages) {
        if (messages.isEmpty()) {
            this.setTop(null);
            return;
        }
        VBox box = this.createMessagesPane();
        for (Message message : messages) {
            MessagePane mp = MessagePane.forMessage(message);
            mp.makeClosable(() -> box.getChildren().remove((Object)mp));
            box.getChildren().add((Object)mp);
        }
        this.setTop((Node)box);
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> void setMessages(Map<Message, IndexListParameters<E, I>> messages, String listTitle) {
        if (messages.isEmpty()) {
            this.setTop(null);
            return;
        }
        VBox box = this.createMessagesPane();
        for (Map.Entry<Message, IndexListParameters<E, I>> set : messages.entrySet()) {
            if (set.getKey() == null) continue;
            ExtendedMessagePane mp = ExtendedMessagePane.forMessage(set.getKey(), set.getValue(), listTitle);
            mp.makeClosable(() -> box.getChildren().remove((Object)mp));
            box.getChildren().add((Object)mp);
        }
        this.setTop((Node)box);
    }

    public void addFlashMessages(Message ... messages) {
        VBox box = (VBox)this.getTop();
        if (box == null) {
            box = this.createMessagesPane();
            this.setTop((Node)box);
        }
        ArrayList<MessagePane> messagePanes = new ArrayList<MessagePane>();
        for (Message message : messages) {
            messagePanes.add(MessagePane.forMessage(message));
        }
        box.getChildren().addAll(messagePanes);
        VBox boxFinal = box;
        Notifications.get().getScheduler().schedule(() -> FxUtil.submitToFxThread(() -> {
            boxFinal.getChildren().removeAll((Collection)messagePanes);
            if (boxFinal.getChildren().isEmpty() && this.getTop() == boxFinal) {
                this.setTop(null);
            }
        }), (long)(5 * messagePanes.size()), TimeUnit.SECONDS);
    }

    private VBox createMessagesPane() {
        VBox box = new VBox();
        box.getStyleClass().add((Object)"messages-pane");
        return box;
    }

    public void showConfigurationPane(Region anchor) {
        final Comparator itemsComparator = (item1, item2) -> this.settings.getPosition(((Tile)item1.getUserData()).getId()) - this.settings.getPosition(((Tile)item2.getUserData()).getId());
        final CustomContextMenu menu = new CustomContextMenu();
        menu.getStyleClass().add((Object)"tiles-configuration-menu");
        for (final Tile tile : this.tiles) {
            if (this.hiddenTiles.contains((Object)tile) || this.forbiddenTiles.contains((Object)tile)) continue;
            final CustomCheckMenuItem menuItem = new CustomCheckMenuItem(tile.getCaption());
            ArrayList<CustomMenuItem.MenuItemButton> buttons = new ArrayList<CustomMenuItem.MenuItemButton>();
            buttons.add(new CustomMenuItem.MenuItemButton(){

                @Override
                public IconShape getShape() {
                    return StandardIconShapes.MOVE_UP_14X14;
                }

                @Override
                public IconIntention getIntention() {
                    return StandardIconIntentions.MENU_ITEM_BUTTON_MOVE;
                }

                @Override
                public boolean isPersistent() {
                    return false;
                }

                @Override
                public boolean isEnabled() {
                    return menu.getItems().indexOf((Object)menuItem) > 0;
                }

                @Override
                public void handle() {
                    int index = menu.getItems().indexOf((Object)menuItem);
                    if (index <= 0) {
                        return;
                    }
                    TilesSpace.this.settings.setPosition(tile.getId(), index - 1, true);
                    TilesSpace.this.settings.setPosition(((Tile)((MenuItem)menu.getItems().get(index - 1)).getUserData()).getId(), index, true);
                    Collections.sort(menu.getItems(), itemsComparator);
                    menu.update();
                    TilesSpace.this.requestLayout();
                }
            });
            buttons.add(new CustomMenuItem.MenuItemButton(){

                @Override
                public IconShape getShape() {
                    return StandardIconShapes.MOVE_DOWN_14X14;
                }

                @Override
                public IconIntention getIntention() {
                    return StandardIconIntentions.MENU_ITEM_BUTTON_MOVE;
                }

                @Override
                public boolean isPersistent() {
                    return false;
                }

                @Override
                public boolean isEnabled() {
                    return menu.getItems().indexOf((Object)menuItem) < menu.getItems().size() - 1;
                }

                @Override
                public void handle() {
                    int index = menu.getItems().indexOf((Object)menuItem);
                    if (index >= menu.getItems().size() - 1) {
                        return;
                    }
                    TilesSpace.this.settings.setPosition(tile.getId(), index + 1, true);
                    TilesSpace.this.settings.setPosition(((Tile)((MenuItem)menu.getItems().get(index + 1)).getUserData()).getId(), index, true);
                    Collections.sort(menu.getItems(), itemsComparator);
                    menu.update();
                    TilesSpace.this.requestLayout();
                }
            });
            menuItem.setChecked(!this.settings.isOffScreen(tile.getId()));
            menuItem.setUserData(tile);
            menuItem.getButtons().clear();
            menuItem.getButtons().addAll(buttons);
            menuItem.checkedProperty().addListener((observable, oldValue, newValue) -> {
                this.settings.setOffScreen(tile.getId(), !menuItem.isChecked());
                this.requestLayout();
            });
            menu.getItems().add((Object)menuItem);
        }
        Collections.sort(menu.getItems(), itemsComparator);
        menu.show((Node)anchor, Side.BOTTOM, 0.0, 0.0);
    }

    protected boolean isVisible(Tile<?, ?> tile) {
        return !this.hiddenTiles.contains(tile) && !this.forbiddenTiles.contains(tile) && !this.settings.isOffScreen(tile.getId());
    }

    private int calculateColumnsCount() {
        double width = this.getWidth();
        int[] arr = this.superCompactMode ? WIDTHS_SUPER_COMPACT : WIDTHS_STANDARD;
        for (int i = 0; i < arr.length; ++i) {
            if (!(width <= (double)arr[i]) && this.maxColumnsCount != i + 1) continue;
            return i + 1;
        }
        return this.maxColumnsCount;
    }

    private void updateView() {
        if (this.tiles.size() == 1 && this.overview == null) {
            ((Tile)this.tiles.get(0)).setExpanded(true);
        }
        boolean foundExpanded = false;
        for (Tile tile : this.tiles) {
            TilePane pane = tile.getExpandedPane();
            if (this.isVisible(tile) && tile.isExpanded()) {
                if (pane == null) {
                    pane = new TilePane(tile, true);
                    tile.setExpandedPane(pane);
                    this.stackPane.getChildren().add(pane);
                } else if (!this.stackPane.getChildren().contains(pane)) {
                    this.stackPane.getChildren().add(pane);
                }
                pane.updateControlsPane(true);
                pane.setVisible(true);
                foundExpanded = true;
                continue;
            }
            if (pane == null) continue;
            pane.setVisible(false);
        }
        if (foundExpanded) {
            this.mosaicScrollPane.setVisible(false);
        } else {
            this.mosaicScrollPane.setVisible(true);
        }
        this.revalidateActions();
    }

    private void updateMosaic() {
        if (this.columnsCount == 0) {
            this.columnsCount = this.calculateColumnsCount();
        }
        ArrayList panes = new ArrayList(this.tiles.size());
        for (Tile tile : this.tiles) {
            if (!this.isVisible(tile)) continue;
            TilePane pane = tile.getCollapsedPane();
            if (pane == null) {
                pane = new TilePane(tile, false);
                tile.setCollapsedPane(pane);
            }
            panes.add(pane);
        }
        Collections.sort(panes, (pane1, pane2) -> this.settings.getPosition(pane1.getTile().getId()) - this.settings.getPosition(pane2.getTile().getId()));
        int col = 0;
        int row = 0;
        int rowsCount = 0;
        ArrayList<TilePane> nodes = new ArrayList<TilePane>(panes.size() + 1);
        if (this.overview != null) {
            GridPane.setConstraints(this.overview, (int)0, (int)0, (int)Integer.MAX_VALUE, (int)1);
            ++row;
            rowsCount = 1;
            nodes.add(this.overview);
        }
        for (TilePane tilePane : panes) {
            rowsCount = row + 1;
            nodes.add(tilePane);
            tilePane.revalidateActions();
            GridPane.setConstraints((Node)tilePane, (int)col, (int)row, (int)1, (int)1);
            GridPane.setFillHeight((Node)tilePane, null);
            GridPane.setVgrow((Node)tilePane, null);
            if (++col < this.columnsCount) continue;
            col = 0;
            ++row;
        }
        if (this.columnsCount != this.mosaicPane.getColumnConstraints().size()) {
            ArrayList<ColumnConstraints> columnConstraints = new ArrayList<ColumnConstraints>(this.columnsCount);
            double total = 0.0;
            for (int i = 0; i < this.columnsCount; ++i) {
                ColumnConstraints cc = new ColumnConstraints();
                double width = i == this.columnsCount - 1 ? 100.0 - total : 100.0 / (double)this.columnsCount;
                cc.setPercentWidth(width);
                columnConstraints.add(cc);
                total += width;
            }
            this.mosaicPane.getColumnConstraints().setAll(columnConstraints);
        }
        ArrayList<RowConstraints> rowConstraints = new ArrayList<RowConstraints>(rowsCount);
        for (int i = 0; i < rowsCount; ++i) {
            rowConstraints.add(new RowConstraints(Double.NEGATIVE_INFINITY, -1.0, Double.NEGATIVE_INFINITY));
        }
        this.mosaicPane.getRowConstraints().setAll(rowConstraints);
        this.mosaicPane.getChildren().setAll(nodes);
        this.updateView();
    }

    void setExpanded(Tile<?, ?> tile, boolean expanded) {
        if (tile.isExpanded() == expanded) {
            return;
        }
        if (expanded) {
            for (Tile tl : this.tiles) {
                if (tl.equals(tile)) continue;
                tl.setExpanded(false);
            }
        }
        tile.setExpanded(expanded);
        this.updateView();
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                ArrayList<DevTool> result = new ArrayList<DevTool>(ControllersRegistry.buildDevToolsFor(TilesSpace.this.getClass().getName() + "Controller"));
                if (TilesSpace.this.overview != null) {
                    result.add(TilesSpace.this.overview.getTile());
                }
                result.addAll((Collection<DevTool>)TilesSpace.this.tiles);
                return result;
            }

            @Override
            public String getInfo() {
                return TilesSpace.this.getClass().getSimpleName() + " [TilesSpace]";
            }
        };
    }
}

