/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

class CheckBoxWidgetSkin
extends LabeledSkinBase<CheckBox, ButtonBehavior<CheckBox>> {
    private static final double HEIGHT_GAP = 1.0;
    private final StackPane box = new StackPane();
    private final Region underline;

    CheckBoxWidgetSkin(CheckBox checkbox) {
        super((Labeled)checkbox, (BehaviorBase)new ButtonBehavior((ButtonBase)checkbox));
        this.box.getStyleClass().add((Object)"box");
        StackPane innerbox = new StackPane();
        innerbox.getStyleClass().add((Object)"mark");
        innerbox.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.box.getChildren().add((Object)innerbox);
        this.underline = new Region();
        this.underline.getStyleClass().add((Object)"xtrip-underline");
        this.getChildren().addAll((Object[])new Node[]{this.box, this.underline});
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.box != null) {
            this.getChildren().add((Object)this.box);
        }
        if (this.underline != null) {
            this.getChildren().add((Object)this.underline);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.minWidth(-1.0));
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(super.computeMinHeight(width - this.box.minWidth(-1.0), topInset, rightInset, bottomInset, leftInset), topInset + this.box.minHeight(-1.0) + bottomInset);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.prefWidth(-1.0));
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(super.computePrefHeight(width - this.box.prefWidth(-1.0), topInset, rightInset, bottomInset, leftInset), topInset + this.box.prefHeight(-1.0) + bottomInset);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        CheckBox checkBox = (CheckBox)this.getSkinnable();
        double boxWidth = this.snapSize(this.box.prefWidth(-1.0));
        double boxHeight = this.snapSize(this.box.prefHeight(-1.0));
        double computeWidth = Math.max(checkBox.prefWidth(-1.0), checkBox.minWidth(-1.0));
        double labelWidth = Math.min(computeWidth - boxWidth, w - this.snapSize(boxWidth));
        double labelHeight = Math.min(checkBox.prefHeight(labelWidth), h);
        double maxHeight = Math.max(boxHeight, labelHeight);
        double xOffset = UiUtil.computeXOffset(w, labelWidth + boxWidth, checkBox.getAlignment().getHpos()) + x;
        double yOffset = UiUtil.computeYOffset(h, maxHeight, checkBox.getAlignment().getVpos()) + x;
        this.layoutLabelInArea(xOffset + boxWidth, yOffset, labelWidth, maxHeight, checkBox.getAlignment());
        this.box.resize(boxWidth, boxHeight);
        this.positionInArea((Node)this.box, xOffset, yOffset, boxWidth, maxHeight, 0.0, checkBox.getAlignment().getHpos(), checkBox.getAlignment().getVpos());
        Bounds bounds = UiUtil.computeTextBounds((Labeled)checkBox);
        double underlineWidth = labelWidth - checkBox.getGraphicTextGap();
        double underlineHeight = Math.ceil(checkBox.getBaselineOffset() + 1.0);
        this.underline.resize(underlineWidth, underlineHeight);
        this.positionInArea((Node)this.underline, UiUtil.computeXOffset(w, underlineWidth, HPos.RIGHT), UiUtil.computeYOffset(h, underlineHeight, VPos.CENTER), underlineWidth, underlineHeight, 0.0, checkBox.getAlignment().getHpos(), checkBox.getAlignment().getVpos());
    }
}

