/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomDatePicker;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class DateValueWidget
extends StackPane
implements HasViewState,
HasValue<LocalDate> {
    private final ObjectProperty<LocalDate> value = new SimpleObjectProperty();
    private Label readonlyLabel;
    protected CustomDatePicker datePicker;
    private String formatPattern;
    protected final List<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
    private final ViewState viewState = new ViewState();
    private String promptText;
    private Predicate<LocalDate> valueValidator;
    private ActionData actionData;
    private boolean ignoreValueChange;

    public DateValueWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.promptText = ro ? "\u2014" : UiUtil.NULL_TEXT;
        this.getStyleClass().addAll((Object[])new String[]{"date-value-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.value.addListener((src, o, n) -> this.renderValue());
        this.setFormatPattern(LocaleManager.get().getCurrentLocaleData().getDateFormatPattern());
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> {
            this.promptText = this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
            this.updateState();
        });
    }

    public void requestFocus() {
        if (this.datePicker != null) {
            this.datePicker.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setFormatPattern(String val) {
        this.formatPattern = Objects.requireNonNull(val);
        this.formatters.clear();
        this.formatters.add(DateTimeFormatter.ofPattern(this.formatPattern));
        String altPattern = this.formatPattern.replaceAll("[\\.\\-/]", "");
        if (this.formatPattern.equals(altPattern)) {
            altPattern = null;
        } else {
            this.formatters.add(DateTimeFormatter.ofPattern(altPattern));
        }
        if (this.formatPattern.contains("yyyy")) {
            this.formatters.add(DateTimeFormatter.ofPattern(this.formatPattern.replace("yyyy", "yy")));
            if (altPattern != null) {
                this.formatters.add(DateTimeFormatter.ofPattern(altPattern.replace("yyyy", "yy")));
            }
        }
        this.datePicker = null;
        this.updateState();
    }

    @Override
    public ObjectProperty<LocalDate> valueProperty() {
        return this.value;
    }

    public LocalDate getValue() {
        return (LocalDate)this.value.get();
    }

    public void setValue(LocalDate val) {
        this.value.set((Object)val);
    }

    public void setValidator(Predicate<LocalDate> val) {
        this.valueValidator = val;
    }

    public void setActionHandler(IconShape iconShape, String tooltip, Consumer<Region> handler) {
        this.setActionHandler(iconShape, tooltip, handler, null);
    }

    public void setActionHandler(IconShape iconShape, String tooltip, Consumer<Region> handler, BooleanExpression availability) {
        this.actionData = handler == null ? null : new ActionData(Objects.requireNonNull(iconShape), tooltip, handler, availability);
        this.updateState();
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.datePicker = null;
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.datePicker == null) {
                this.datePicker = new CustomDatePicker();
                this.datePicker.setMaxWidth(Double.MAX_VALUE);
                this.datePicker.setConverter((StringConverter)new StringConverter<LocalDate>(){

                    public String toString(LocalDate date) {
                        return date == null ? null : date.format(DateValueWidget.this.formatters.get(0));
                    }

                    public LocalDate fromString(String string) {
                        if (TextUtil.isBlank((String)string)) {
                            return null;
                        }
                        for (DateTimeFormatter formatter : DateValueWidget.this.formatters) {
                            try {
                                LocalDate date = LocalDate.parse(string, formatter);
                                if (Math.abs(date.getYear() - LocalDate.now().getYear()) >= 100) {
                                    UiUtil.blink((Node)DateValueWidget.this.datePicker);
                                    return null;
                                }
                                return date;
                            }
                            catch (DateTimeParseException dateTimeParseException) {
                            }
                        }
                        throw Xeption.forEndUser((String)Messages.General_Unsupported_date_format, (Object[])new Object[0]);
                    }
                });
                String prompt = this.formatPattern.toLowerCase();
                if ("ru".equals(LocaleManager.get().getCurrentLocaleData().getLocale().getLanguage())) {
                    prompt = prompt.replace('d', '\u0434').replace('m', '\u043c').replace('l', '\u043c').replace('y', '\u0433');
                }
                this.datePicker.setPromptText(prompt);
                this.datePicker.valueProperty().addListener((s, o, n) -> {
                    if (this.ignoreValueChange) {
                        return;
                    }
                    if (this.valueValidator != null && !this.valueValidator.test((LocalDate)n)) {
                        UiUtil.blink((Node)this.datePicker);
                        this.value.set(o);
                        this.renderValue();
                    } else {
                        this.value.set(n);
                    }
                });
            }
            if (this.actionData != null) {
                HBox.setHgrow((Node)this.datePicker, (Priority)Priority.ALWAYS);
                Button button = new Button();
                button.setOnAction(evt -> this.actionData.handler.accept((Region)button));
                button.setGraphic((Node)new IconNode(this.actionData.shape, (Styleable)button, StandardIconIntentions.CONTROLS_QTY, (Styleable)button));
                if (!TextUtil.isBlank((String)this.actionData.tooltip)) {
                    UiUtil.setTooltip((Node)button, this.actionData.tooltip);
                }
                if (this.actionData.availability != null) {
                    button.disableProperty().bind((ObservableValue)this.actionData.availability.not());
                }
                button.getStyleClass().add((Object)"xtrip-button");
                this.getChildren().setAll((Object[])new Node[]{new HBox(new Node[]{this.datePicker, button})});
            } else {
                this.getChildren().setAll((Object[])new Node[]{this.datePicker});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void renderValue() {
        LocalDate val = (LocalDate)this.value.get();
        if (this.readonlyLabel != null) {
            this.readonlyLabel.setText(val == null ? this.promptText : this.formatters.get(0).format(val));
        } else {
            this.ignoreValueChange = true;
            try {
                this.datePicker.setValue(val);
            }
            finally {
                this.ignoreValueChange = false;
            }
        }
    }

    public boolean hasSameValue(LocalDate val) {
        LocalDate current = (LocalDate)this.value.get();
        if (current == null && val == null) {
            return true;
        }
        if (current == null || val == null) {
            return false;
        }
        DateTimeFormatter formatter = this.formatters.get(0);
        return formatter.format(current).equalsIgnoreCase(formatter.format(val));
    }

    private static class ActionData {
        final IconShape shape;
        final String tooltip;
        final Consumer<Region> handler;
        final BooleanExpression availability;

        ActionData(IconShape is, String tt, Consumer<Region> h, BooleanExpression a) {
            this.shape = is;
            this.tooltip = tt;
            this.handler = h;
            this.availability = a;
        }
    }
}

