/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoPanelWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;

public class FileChooserWidget
extends GridPane
implements HasViewState {
    private final InfoPanelWidget filesWidget;
    private final HyperlinkWidget chooserWidget;
    private HyperlinkWidget resetWidget;
    protected final ObservableList<File> files = FXCollections.observableArrayList();
    private final ViewState viewState = new ViewState();
    private ObjectProperty<ChoosingMode> mode = new ObjectPropertyBase<ChoosingMode>(){

        public Object getBean() {
            return FileChooserWidget.this;
        }

        public String getName() {
            return "mode";
        }
    };
    private String fieldName;
    final SimpleStringProperty fileExtension = new SimpleStringProperty();
    private Supplier<List<FileChooser.ExtensionFilter>> extensionFiltersSupplier;
    private byte[] content;

    public FileChooserWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"file-chooser-widget", "simple-widget"});
        this.mode.set((Object)ChoosingMode.OPEN_SINGLE);
        this.filesWidget = new InfoPanelWidget();
        this.filesWidget.textProperty().bind((ObservableValue)new StringBinding(){
            {
                this.bind(new Observable[]{FileChooserWidget.this.files, FileChooserWidget.this.fileExtension, FileChooserWidget.this.mode});
            }

            protected String computeValue() {
                if (FileChooserWidget.this.isListEmpty((List<File>)FileChooserWidget.this.files)) {
                    return FileChooserWidget.this.getMode() == ChoosingMode.CHOOSE_DIRECTORY ? Messages.General_Directory_not_choosen : Messages.General_File_not_choosen;
                }
                String res = "";
                ArrayList<File> updatedFiles = new ArrayList<File>();
                for (File file : FileChooserWidget.this.files) {
                    if (res.length() > 0) {
                        res = res + '\n';
                    }
                    String fileName = FileChooserWidget.this.checkExtension(FileChooserWidget.this.getMode() == ChoosingMode.SAVE_IMMEDIATELY ? FilenameUtils.getName((String)file.getAbsolutePath()) : file.getAbsolutePath());
                    res = res + fileName;
                    updatedFiles.add(new File(fileName));
                }
                FileChooserWidget.this.files.clear();
                FileChooserWidget.this.files.addAll(updatedFiles);
                return res;
            }
        });
        GridPane.setConstraints((Node)this.filesWidget, (int)0, (int)0);
        GridPane.setHgrow((Node)this.filesWidget, (Priority)Priority.ALWAYS);
        this.chooserWidget = new HyperlinkWidget();
        this.chooserWidget.setText(Messages.General_Choose_file);
        this.chooserWidget.setMinWidth(Double.NEGATIVE_INFINITY);
        this.chooserWidget.setOnAction(evt -> this.chooseFile());
        GridPane.setConstraints((Node)this.chooserWidget, (int)1, (int)0);
        GridPane.setValignment((Node)this.chooserWidget, (VPos)VPos.TOP);
        this.getChildren().addAll((Object[])new Node[]{this.filesWidget, this.chooserWidget});
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    String checkExtension(String fileName) {
        String widgetExtension;
        String ext = FilenameUtils.getExtension((String)fileName);
        String string = widgetExtension = !TextUtil.isBlank((String)this.fileExtension.get()) ? this.fileExtension.get() : "";
        if (!TextUtil.isBlank((String)ext) && !TextUtil.isBlank((String)widgetExtension) && fileName.length() > ext.length() + 1) {
            return fileName.substring(0, fileName.length() - ext.length() - 1) + widgetExtension;
        }
        if (!TextUtil.isBlank((String)widgetExtension)) {
            return fileName + widgetExtension;
        }
        return fileName;
    }

    private void chooseFile() {
        File file;
        if (this.mode.get() == ChoosingMode.CHOOSE_DIRECTORY) {
            File selectedDirectory;
            File file2;
            DirectoryChooser dc = new DirectoryChooser();
            dc.setTitle(Messages.General_Choose_Directory);
            if (!this.isListEmpty((List<File>)this.files)) {
                file2 = (File)this.files.get(0);
                if (file2.isFile()) {
                    file2 = file2.getParentFile();
                }
                if (file2.isDirectory()) {
                    dc.setInitialDirectory(file2.getParentFile());
                }
            }
            if (dc.getInitialDirectory() == null) {
                file2 = ClientSettings.get().getFileChooserDirectory();
                if (UiUtil.isFileValid(file2) && file2.isDirectory()) {
                    dc.setInitialDirectory(file2);
                } else {
                    dc.setInitialDirectory(Environment.getDataFolder());
                }
            }
            if ((selectedDirectory = dc.showDialog(this.getScene().getWindow())) != null) {
                ClientSettings.get().setFileChooserDirectory(selectedDirectory);
                ClientSettings.get().save();
                this.files.setAll((Object[])new File[]{selectedDirectory});
            }
            return;
        }
        FileChooser fc = new FileChooser();
        if (!this.isListEmpty((List<File>)this.files)) {
            file = (File)this.files.get(0);
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (file.isDirectory()) {
                fc.setInitialDirectory(file);
            }
        }
        if (fc.getInitialDirectory() == null) {
            file = ClientSettings.get().getFileChooserDirectory();
            if (UiUtil.isFileValid(file) && file.isDirectory()) {
                fc.setInitialDirectory(file);
            } else {
                fc.setInitialDirectory(Environment.getDataFolder());
            }
        }
        if (this.fieldName != null) {
            fc.setTitle(this.fieldName);
        }
        if (this.extensionFiltersSupplier != null) {
            fc.getExtensionFilters().setAll((Collection)this.extensionFiltersSupplier.get());
        }
        switch ((ChoosingMode)((Object)this.mode.get())) {
            case SAVE: {
                file = fc.showSaveDialog(this.getScene().getWindow());
                if (file == null) break;
                String extension = file.getPath().substring(file.getPath().length() - 4);
                if (extension.equals(".xml")) {
                    this.fileExtension.set(".xml");
                } else if (extension.equals(".xls")) {
                    this.fileExtension.set(".xls");
                } else if (extension.equals(".csv")) {
                    this.fileExtension.set(".csv");
                } else if (extension.equals(".zip")) {
                    this.fileExtension.set(".zip");
                }
                this.files.setAll((Object[])new File[]{file});
                ClientSettings.get().setFileChooserDirectory(file.getParentFile());
                ClientSettings.get().save();
                break;
            }
            case SAVE_IMMEDIATELY: {
                file = fc.showSaveDialog(this.getScene().getWindow());
                if (file == null) break;
                ClientSettings.get().setFileChooserDirectory(file.getParentFile());
                ClientSettings.get().save();
                FxUtil.saveToFile(file, this.content);
                break;
            }
            case OPEN_SINGLE: {
                file = fc.showOpenDialog(this.getScene().getWindow());
                if (file == null) break;
                this.files.setAll((Object[])new File[]{file});
                ClientSettings.get().setFileChooserDirectory(file.getParentFile());
                ClientSettings.get().save();
                break;
            }
            case OPEN_MULTIPLE: {
                List fls = fc.showOpenMultipleDialog(this.getScene().getWindow());
                if (fls == null || this.isListEmpty(fls)) break;
                this.files.setAll((Collection)fls);
                ClientSettings.get().setFileChooserDirectory(((File)fls.get(0)).getParentFile());
                ClientSettings.get().save();
                break;
            }
        }
    }

    public ChoosingMode getMode() {
        return (ChoosingMode)((Object)this.mode.get());
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    public void setMode(ChoosingMode value) {
        this.mode.set((Object)Objects.requireNonNull(value));
        this.updateState();
    }

    public void setExtensionFiltersSupplier(Supplier<List<FileChooser.ExtensionFilter>> value) {
        this.extensionFiltersSupplier = value;
    }

    public void setDefaultFilePathBuilder(String defaultPath) {
        if (defaultPath == null) {
            if (this.resetWidget != null) {
                this.getChildren().remove((Object)this.resetWidget);
                this.resetWidget = null;
            }
            return;
        }
        this.resetWidget = new HyperlinkWidget();
        this.resetWidget.setOnAction(evt -> {
            File file = new File(defaultPath);
            this.files.setAll((Object[])new File[]{file});
        });
        this.resetWidget.setText(Messages.General_By_default);
        this.resetWidget.setMinWidth(Double.NEGATIVE_INFINITY);
        GridPane.setConstraints((Node)this.resetWidget, (int)2, (int)0);
        GridPane.setValignment((Node)this.resetWidget, (VPos)VPos.TOP);
        this.updateState();
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public StringProperty fileExtensionProperty() {
        return this.fileExtension;
    }

    public String getFileExtension() {
        return this.fileExtension.get();
    }

    public void setFileExtension(String value) {
        this.fileExtension.set(value);
    }

    private void updateState() {
        boolean disabled = this.viewState.isImmutable();
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, disabled);
        if (disabled) {
            this.getChildren().remove((Object)this.chooserWidget);
            if (this.resetWidget != null) {
                this.getChildren().remove((Object)this.resetWidget);
            }
            return;
        }
        if (!this.getChildren().contains((Object)this.chooserWidget)) {
            this.getChildren().add((Object)this.chooserWidget);
        }
        if (this.resetWidget != null && !this.getChildren().contains((Object)this.resetWidget)) {
            this.getChildren().add((Object)this.resetWidget);
        }
        if (this.mode.get() == ChoosingMode.SAVE_IMMEDIATELY) {
            this.chooserWidget.setText(Messages.General_Save);
        } else {
            this.chooserWidget.setText(Messages.General_Choose_file);
        }
        if (this.mode.get() == ChoosingMode.CHOOSE_DIRECTORY) {
            this.chooserWidget.setText(Messages.General_Choose_Folder);
        }
    }

    public ObservableList<File> getFiles() {
        return this.files;
    }

    public void setContent(byte[] cnt) {
        this.content = cnt;
    }

    boolean isListEmpty(List<File> list) {
        return list.stream().filter(f -> f != null).collect(Collectors.toList()).size() == 0;
    }

    public static enum ChoosingMode {
        SAVE,
        SAVE_IMMEDIATELY,
        OPEN_SINGLE,
        OPEN_MULTIPLE,
        CHOOSE_DIRECTORY;

    }
}

